﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.Package.Domain;

namespace VIZ.Package.Common
{
    /// <summary>
    /// 列定义模板选择器
    /// </summary>
    public class ColumnDefintionGeneratorTemplateSelector : DataTemplateSelector
    {
        /// <summary>
        /// 模板集合
        /// </summary>
        public ColumnDefintionGeneratorTemplateCollection Templates { get; set; }

        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            if (this.Templates == null || this.Templates.Count == 0)
                return null;

            GridColumnDefinition defintion = item as GridColumnDefinition;
            if (defintion == null)
                return null;

            ColumnDefintionGeneratorTemplate template = this.Templates.FirstOrDefault(p => p.ColumnKey == defintion.ColumnKey);
            if (template == null)
                return null;

            return template.DataTemplate;
        }
    }
}
