﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 应用程序常量
    /// </summary>
    public static class ApplicationConstants
    {
        /// <summary>
        /// 系统分组
        /// </summary>
        public const string APPLICATION_GROUP_NAME = "APPLICATION_GROUP";

        /// <summary>
        /// 项目文件扩展名
        /// </summary>
        public const string PROJECT_FILE_EXTENSION = ".viz_pkg";

        /// <summary>
        /// 项目日志文件后缀
        /// </summary>
        public const string PROJECT_FILE_LOG_NAME_SUFFIX = "-log.viz_pkg";

        /// <summary>
        /// 项目文件过滤器
        /// </summary>
        public const string PROJECT_FILE_FILTER = "viz_pkg files(*.viz_pkg)|*.viz_pkg";

        /// <summary>
        /// VIZ命令返回错误前缀
        /// </summary>
        public const string VIZ_COMMAND_RESULT_ERROR_PREFIX = "ERROR";

        /// <summary>
        /// VIZ自定义字段定义方法名
        /// </summary>
        public const string VIZ_COMMAND_CUSTOM_CONTROL_FIELD_DEFINE = "VIZ_CUSTOM_CONTROL_FIELD_DEFINE";

        /// <summary>
        /// VIZ自定义字段
        /// </summary>
        public const string VIZ_COMMAND_CUSTOM_CONTROL_FIELD_SET = "VIZ_CUSTOM_CONTROL_FIELD_SET";

        /// <summary>
        /// VIZ切换逻辑默认出点
        /// </summary>
        public const string VIZ_TRANSITIONLOGIC_DEFAULT_OUT = "O";

        /// <summary>
        /// Viz 层集合
        /// </summary>
        public readonly static List<VizLayer> VIZ_LAYERS = new List<VizLayer> { VizLayer.FRONT_LAYER, VizLayer.MAIN_LAYER, VizLayer.BACK_LAYER };
    }
}
