﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 应用程序域方法
    /// </summary>
    public partial class ApplicationDomainEx
    {
        /// <summary>
        /// 根据页获取场景信息
        /// </summary>
        /// <param name="page">页</param>
        /// <returns>场景信息</returns>
        public static SceneInfoModel GetSceneInfo(PageModel page)
        {
            SceneInfoModel sceneInfo = ApplicationDomainEx.SceneInfoList.FirstOrDefault(p => p.ScenePath == page.ScenePath && p.ConnGroupID == p.ConnGroupID);
            if (sceneInfo != null)
                return sceneInfo;

            lock (ApplicationDomainEx.SceneInfoList)
            {
                SceneInfoModel sceneInfoInner = ApplicationDomainEx.SceneInfoList.FirstOrDefault(p => p.ScenePath == page.ScenePath && p.ConnGroupID == p.ConnGroupID);
                if (sceneInfoInner != null)
                    return sceneInfoInner;

                sceneInfo = new SceneInfoModel();
                sceneInfo.ConnGroupID = page.ConnGroupID;
                sceneInfo.Scene = page.Scene;
                sceneInfo.ScenePath = page.ScenePath;

                ApplicationDomainEx.SceneInfoList.Add(sceneInfo);
            }

            return sceneInfo;
        }

        /// <summary>
        /// 根据场景模板获取场景信息
        /// </summary>
        /// <param name="template">模板</param>
        /// <returns>场景信息</returns>
        public static SceneInfoModel GetSceneInfo(PageTemplateModel template)
        {
            ConnGroupModel group = ApplicationDomainEx.ConnGroups.FirstOrDefault(p => p.IsDefault);
            if (group == null)
                return null;

            SceneInfoModel sceneInfo = ApplicationDomainEx.SceneInfoList.FirstOrDefault(p => p.ScenePath == template.ScenePath && p.ConnGroupID == group.GroupID);
            if (sceneInfo != null)
                return sceneInfo;

            lock (ApplicationDomainEx.SceneInfoList)
            {
                SceneInfoModel sceneInfoInner = ApplicationDomainEx.SceneInfoList.FirstOrDefault(p => p.ScenePath == template.ScenePath && p.ConnGroupID == p.ConnGroupID);
                if (sceneInfoInner != null)
                    return sceneInfoInner;

                sceneInfo = new SceneInfoModel();
                sceneInfo.ConnGroupID = group.GroupID;
                sceneInfo.Scene = template.Scene;
                sceneInfo.ScenePath = template.ScenePath;

                ApplicationDomainEx.SceneInfoList.Add(sceneInfo);
            }

            return sceneInfo;
        }

        /// <summary>
        /// 根据页或模板获取背景场景信息
        /// </summary>
        /// <param name="pageBase">页或模板</param>
        /// <returns>背景场景信息</returns>
        public static TransitionLogicSceneInfoModel GetSceneInfoWithTransitionLogic(ConnModel conn, PageModelBase pageBase)
        {
            if (string.IsNullOrWhiteSpace(pageBase.BackgroundScene))
                return null;

            string bgScenePath = $"{pageBase.GetSceneParent()}/{pageBase.BackgroundScene}";

            Guid collectionGroupID = Guid.Empty;
            if (pageBase is PageTemplateModel template)
            {
                ConnGroupModel group = ApplicationDomainEx.ConnGroups.FirstOrDefault(p => p.IsDefault);
                collectionGroupID = group == null ? Guid.Empty : group.GroupID;
            }
            if (pageBase is PageModel page)
            {
                collectionGroupID = page.ConnGroupID;
            }

            TransitionLogicSceneInfoModel sceneInfo = ApplicationDomainEx.SceneInfoListWithTransitionLogic.FirstOrDefault(p => p.ScenePath == bgScenePath &&
                                                                                                                               p.ConnGroupID == collectionGroupID &&
                                                                                                                               p.Connection == conn);
            if (sceneInfo != null)
                return sceneInfo;

            lock (ApplicationDomainEx.SceneInfoList)
            {
                TransitionLogicSceneInfoModel sceneInfoInner = ApplicationDomainEx.SceneInfoListWithTransitionLogic.FirstOrDefault(p => p.ScenePath == bgScenePath &&
                                                                                                                                        p.ConnGroupID == collectionGroupID &&
                                                                                                                                        p.Connection == conn);
                if (sceneInfoInner != null)
                    return sceneInfoInner;

                sceneInfo = new TransitionLogicSceneInfoModel();
                sceneInfo.Scene = pageBase.BackgroundScene;
                sceneInfo.ScenePath = bgScenePath;
                sceneInfo.ConnGroupID = collectionGroupID;
                sceneInfo.Connection = conn;

                ApplicationDomainEx.SceneInfoListWithTransitionLogic.Add(sceneInfo);
            }

            return sceneInfo;
        }
    }
}
