﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain.Model
{
    /// <summary>
    /// 菜单项
    /// </summary>
    public class MenuItemModel : ModelBase
    {
        #region Icon -- 图标

        private string icon;
        /// <summary>
        /// 图标
        /// </summary>
        public string Icon
        {
            get { return icon; }
            set { icon = value; this.RaisePropertyChanged(nameof(Icon)); }
        }

        #endregion

        #region Header -- 头部

        private object header;
        /// <summary>
        /// 头部
        /// </summary>
        public object Header
        {
            get { return header; }
            set { header = value; this.RaisePropertyChanged(nameof(Header)); }
        }

        #endregion

        #region Data -- 数据

        private object data;
        /// <summary>
        /// 数据
        /// </summary>
        public object Data
        {
            get { return data; }
            set { data = value; this.RaisePropertyChanged(nameof(Data)); }
        }

        #endregion

        #region Type -- 菜单类型

        private MenuItemType type;
        /// <summary>
        /// 菜单类型
        /// </summary>
        public MenuItemType Type
        {
            get { return type; }
            set { type = value; this.RaisePropertyChanged(nameof(Type)); }
        }

        #endregion

        #region 文件路径

        private string filePath;


        /// <summary>
        /// 文件路径
        /// </summary>
        public string FilePath
        {
            get { return filePath; }
            set { filePath=value; this.RaisePropertyChanged(nameof(FilePath)); }    
        }
        #endregion

        #region Command -- 命令

        private VCommand<string> command;
        /// <summary>
        /// 命令
        /// </summary>
        public VCommand<string> Command
        {
            get { return command; }
            set { command = value; this.RaisePropertyChanged(nameof(Command)); }
        }


        #endregion
    }
}
