﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 错误窗口模型
    /// </summary>
    public class ErrorLogWindowModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(ErrorLogWindowModel));

        /// <summary>
        /// 错误窗口模型
        /// </summary>
        public ErrorLogWindowModel()
        {
            // 初始化命令
            this.InitCommand();

            // 初始化消息
            this.InitMessage();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.ClearCommand = new VCommand(this.Clear);
        }

        /// <summary>
        /// 初始化消息
        /// </summary>
        private void InitMessage()
        {
            ApplicationDomainEx.MessageManager.Register<ErrorLogMessage>(this, this.OnErrorLogMessage);
        }

        // ==================================================================================
        // Command
        // ==================================================================================

        #region ClearCommand -- 清除消息

        /// <summary>
        /// 清除消息
        /// </summary>
        public VCommand ClearCommand { get; set; }

        /// <summary>
        /// 清除
        /// </summary>
        private void Clear()
        {
            ErrorLogWindow view = this.GetView<ErrorLogWindow>();
            if (view == null)
                return;

            view.tb.Clear();
        }

        #endregion

        // ==================================================================================
        // Message
        // ==================================================================================

        /// <summary>
        /// 错误日志消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnErrorLogMessage(ErrorLogMessage msg)
        {
            WPFHelper.BeginInvoke(() =>
            {
                ErrorLogWindow view = this.GetView<ErrorLogWindow>();
                if (view == null)
                    return;

                string log = $"{DateTime.Now.ToString("HH:mm:ss")} {msg.Error}";

                view.tb.AppendText($"{log}\r\n");
                view.tb.ScrollToEnd();
            });
        }

        // ==================================================================================
        // Public Function
        // ==================================================================================

    }
}