﻿using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Domain.Model;
using VIZ.Package.Service;
using VIZ.Package.Storage;
using static System.Net.WebRequestMethods;
using File = System.IO.File;

namespace VIZ.Package.Module
{

    /// <summary>
    /// 管理布局菜单实体类
    /// </summary>
    public class ManagerLayoutViewModel : ViewModelBase
    {

        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(ManagerLayoutViewModel));

        //获取topViewService服务
        //IMainTopViewService service;
        public ManagerLayoutViewModel()
        {
            //service = ApplicationDomainEx.ServiceManager.GetService<IMainTopViewService>(ViewServiceKeys.MAIN_TOPVIEW_SERVICE);

            // itemsSource = service.ItemsSource.Where(a=> !string.IsNullOrEmpty(a.FilePath)).ToObservableCollection();

            //初始化命令

            this.ReNameCommand = new VCommand(this.ReName);

            this.DeleteCommand = new VCommand(this.Delete);

            this.CloseCommand = new VCommand(this.Close);
        }


        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        #region  视图集合


        /// <summary>
        /// 选中视图集合
        /// </summary>
        private MenuItemModel selectItem;

        public MenuItemModel SelectItem
        {
            get { return selectItem; }
            set { selectItem = value; this.RaisePropertyChanged(nameof(SelectItem)); }
        }


        /// <summary>
        /// 视图项的集合
        /// </summary>
        private ObservableCollection<MenuItemModel> itemsSource;
        /// <summary>
        /// 视图项
        /// </summary>
        public ObservableCollection<MenuItemModel> ItemsSource
        {
            get { return itemsSource; }
            set { itemsSource = value; this.RaisePropertyChanged(nameof(ItemsSource)); }
        }
        #endregion

        #region Command 命令


        /// <summary>
        /// 重命名命令
        /// </summary>
        public VCommand ReNameCommand { get; set; }

        private void ReName()
        {
            if (selectItem == null) return;

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "重命名布局");

            SaveLayoutView saveLayout = new SaveLayoutView();
            SaveLayoutViewModel vm = saveLayout.DataContext as SaveLayoutViewModel;
            vm.TitleName = "重命名窗口布局";
            vm.FolderName = SelectItem.Header.ToString();

            vm.SelectItem = SelectItem;
            vm.ItemsSource = ItemsSource;
            saveLayout.ShowDialog();

        }

        /// <summary>
        /// 删除命令
        /// </summary>
        public VCommand DeleteCommand { get; set; }

        private void Delete()
        {
            if (SelectItem == null) return;

            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, RecordLogOperate.Operate, RecordLogTrigger.Human, "删除布局");

            if (DXMessageBox.Show("是否替确定要删除布局 " + SelectItem.Header, "提示", System.Windows.MessageBoxButton.YesNo) == System.Windows.MessageBoxResult.Yes)
            {
                MenuItemModel tempSelectItem = SelectItem;
                if (File.Exists(SelectItem.FilePath))
                {
                    File.Delete(SelectItem.FilePath);

                    ItemsSource.Remove(SelectItem);

                    IMainTopViewService service = ApplicationDomainEx.ServiceManager.GetService<IMainTopViewService>(ViewServiceKeys.MAIN_TOPVIEW_SERVICE);

                    service.ItemsSource.Remove(tempSelectItem);
                }
            }
        }

        /// <summary>
        /// 关闭命令
        /// </summary>
        public VCommand CloseCommand { get; set; }

        private void Close()
        {
            ManagerLayoutView view = this.GetView<ManagerLayoutView>();
            if (view == null)
                return;
            view.Close();
        }

        #endregion

    }

}
