﻿using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Domain.Model;

namespace VIZ.Package.Module
{
    public class SaveLayoutViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(CreateFolderViewModel));

        /// <summary>
        /// 初始化
        /// </summary>
        public SaveLayoutViewModel()
        {
            EnterCommand = new VCommand(Enter);
            CancelCommand = new VCommand(Cancel);
        }


        public MainView view { get; set; }


        public string createPath { get; set; }
        /// <summary>
        /// 窗口布局名称
        /// </summary>

        private string titleName;

        public string TitleName
        {
            get { return titleName; }
            set { titleName = value; this.RaisePropertyChanged(nameof(TitleName)); }
        }


        private string folderName;

        /// <summary>
        /// 文件夹名称
        /// </summary>
        public string FolderName
        {
            get { return folderName; }
            set { folderName = value; this.RaisePropertyChanged(nameof(FolderName)); }
        }


        private bool isEnter;
        /// <summary>
        /// 是否确定
        /// </summary>
        public bool IsEnter
        {
            get { return isEnter; }
            set { isEnter = value; this.RaisePropertyChanged(nameof(IsEnter)); }
        }

        public VCommand EnterCommand { get; set; }

        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            if (string.IsNullOrWhiteSpace(this.FolderName))
            {
                DXMessageBox.Show("请输入文件名");
                return;
            }
            //this.IsEnter = true;

            //this.GetWindow()?.Close();

            if (TitleName== "保存窗口布局")
            {
                SaveLayout();
            }
            else if(TitleName== "重命名窗口布局")
            {
                ReName();
            }
        }



        private void SaveLayout()
        {
            createPath = System.IO.Path.Combine(createPath, FolderName + ".xml");

            //判断此文件路径是否存在不存在就创建
            string dir = System.IO.Path.GetDirectoryName(createPath);
            if (!System.IO.Directory.Exists(dir))
            {
                System.IO.Directory.CreateDirectory(dir);
            }

            if (File.Exists(createPath))
            {
                if (DXMessageBox.Show("是否替换当前存在布局", "提示", System.Windows.MessageBoxButton.YesNo) == System.Windows.MessageBoxResult.Yes)
                {
                    view.dockLayoutManager.SaveLayoutToXml(createPath);
                    this.GetWindow()?.Close();
                }

            }
            else
            {
                view.dockLayoutManager.SaveLayoutToXml(createPath);

                IMainTopViewService service = ApplicationDomainEx.ServiceManager.GetService<IMainTopViewService>(ViewServiceKeys.MAIN_TOPVIEW_SERVICE);

                service.ItemsSource.Add(new Domain.Model.MenuItemModel()
                {
                    Header = FolderName,
                    Type = MenuItemType.Button,
                    FilePath = createPath,
                    Command = service.ImportLayoutCommand
                });

                this.GetWindow()?.Close();
            }

        }


        public MenuItemModel SelectItem { get; set; }

        public ObservableCollection<MenuItemModel> ItemsSource { get; set; }
        private void  ReName()
        {
            if (File.Exists(SelectItem.FilePath))
            {
                IMainTopViewService service = ApplicationDomainEx.ServiceManager.GetService<IMainTopViewService>(ViewServiceKeys.MAIN_TOPVIEW_SERVICE);

                MenuItemModel tempSelectItem = SelectItem;

                //得到没有扩展的文件名称
                string fileName = Path.GetFileNameWithoutExtension(SelectItem.FilePath);


                //D:\Projects\VIZ.Package\VIZ.Package\bin\x64\Debug\layout\CBA\556.xml

                int index = SelectItem.FilePath.LastIndexOf("\\");  //返回“//”最后一次出现的位置

                string filepath = SelectItem.FilePath.Substring(0, index);

                string newFilePath = filepath + "\\" + FolderName + ".xml";

                if (File.Exists(newFilePath))
                {

                    if (DXMessageBox.Show("是否替换当前存在布局", "提示", System.Windows.MessageBoxButton.YesNo) == System.Windows.MessageBoxResult.Yes)
                    {

                        File.Delete(newFilePath);

                        if (System.IO.File.Exists(SelectItem.FilePath))
                        {
                            FileInfo fi = new FileInfo(SelectItem.FilePath);
                            fi.MoveTo(newFilePath);
                        }

                        //文件管理页面对应的移除
                        ItemsSource.Remove(SelectItem);

                        //视频导航菜单移除

                        service.ItemsSource.Remove(tempSelectItem);

                        this.GetWindow()?.Close();

                    }
                }
                else
                {
                    if (System.IO.File.Exists(SelectItem.FilePath))
                    {
                        FileInfo fi = new FileInfo(SelectItem.FilePath);
                        fi.MoveTo(newFilePath);
                    }

                    SelectItem.Header = FolderName;
                    SelectItem.FilePath = newFilePath;

                    this.GetWindow()?.Close();

                }

            }
        }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            this.IsEnter = false;
            this.GetWindow()?.Close();
        }
    }
}
