﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// Viz预览命令控制器
    /// </summary>
    public class VizPreviewCmdController
    {
        /// <summary>
        /// 上版 -- 命令
        /// </summary>
        /// <param name="pageBase">页</param>
        /// <param name="conn">连接</param>
        public void TakeCommnad(PageModelBase pageBase, ConnModel conn)
        {
            // 执行命令
            IPageCommandService pageCommandService = ApplicationDomainEx.ServiceManager.GetService<IPageCommandService>(ViewServiceKeys.PAGE_COMMAND_SERVICE);
            if (pageCommandService == null)
                return;

            pageCommandService.BeginExecuteTakeCommand(pageBase, conn);
        }

        /// <summary>
        /// 继续 -- 命令
        /// </summary>
        /// <param name="pageBase">页</param>
        /// <param name="conn">连接</param>
        public void ContinueCommnad(PageModelBase pageBase, ConnModel conn)
        {
            // 执行命令
            IPageCommandService pageCommandService = ApplicationDomainEx.ServiceManager.GetService<IPageCommandService>(ViewServiceKeys.PAGE_COMMAND_SERVICE);
            if (pageCommandService == null)
                return;

            pageCommandService.BeginExecuteTakeContinueCommand(pageBase, conn);
        }

        /// <summary>
        /// 下版 -- 命令
        /// </summary>
        /// <param name="pageBase">页</param>
        /// <param name="conn">连接</param>
        public void TakeOutCommnad(PageModelBase pageBase, ConnModel conn)
        {
            // 执行命令
            IPageCommandService pageCommandService = ApplicationDomainEx.ServiceManager.GetService<IPageCommandService>(ViewServiceKeys.PAGE_COMMAND_SERVICE);
            if (pageCommandService == null)
                return;

            pageCommandService.BeginExecuteTakeOutCommand(pageBase, conn);
        }

        /// <summary>
        /// 更新 -- 命令
        /// </summary>
        /// <param name="pageBase">页</param>
        /// <param name="conn">连接</param>
        public void UpdateCommnad(PageModelBase pageBase, ConnModel conn)
        {
            // 执行命令
            IPageCommandService pageCommandService = ApplicationDomainEx.ServiceManager.GetService<IPageCommandService>(ViewServiceKeys.PAGE_COMMAND_SERVICE);
            if (pageCommandService == null)
                return;

            pageCommandService.BeginExecuteTakeUpdateCommand(pageBase, conn);
        }
    }
}
