﻿using DevExpress.Xpf.Core.Native;
using DevExpress.Xpf.Grid;
using DevExpress.Xpf.Grid.TreeList;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Globalization;
using System.Windows.Media;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// GH资源文件夹节点图片选择器
    /// </summary>
    public class GHResourceFolderNodeImageSelector : TreeListNodeImageSelector
    {
        /// <summary>
        /// 文件夹图标
        /// </summary>
        public ImageSource Folder { get; set; }

        /// <summary>
        /// 项目图标
        /// </summary>
        public ImageSource Project { get; set; }

        /// <summary>
        /// 选择图标
        /// </summary>
        /// <param name="rowData">行数据</param>
        /// <returns>图标</returns>
        public override ImageSource Select(TreeListRowData rowData)
        {
            ResourceFolderModelBase model = rowData.Row as ResourceFolderModelBase;
            if (model == null)
                return null;

            if (model.FolderType == ResourceFolderType.Project)
                return this.Project;

            if (model.FolderType == ResourceFolderType.Folder)
                return this.Folder;

            return null;
        }
    }
}
