﻿using log4net;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 绑定
    /// </summary>
    public class ImageEditViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(ImageEditViewModel));

        public ImageEditViewModel()
        {
            ImageCutCommand = new VCommand(this.ImageCut);
        }


        /// <summary>
        /// 截图命令
        /// </summary>
        public VCommand ImageCutCommand { get; set; }


        /// <summary>
        /// 源图
        /// </summary>
        public BitmapImage OriginImage { get; set; }


        /// <summary>
        /// 截图
        /// </summary>
        public Bitmap CutImage { get; set; }



        private bool isEnter=false;
        /// <summary>
        /// 是否确定
        /// </summary>
        public bool IsEnter
        {
            get { return isEnter; }
            set { isEnter = value; this.RaisePropertyChanged(nameof(IsEnter)); }
        }






        /// <summary>
        /// BitMapImage转Bitmap
        /// </summary>
        /// <param name="bitmapImage"></param>
        /// <returns></returns>
        public Bitmap BitmapImage2Bitmap(BitmapImage bitmapImage)
        {
            using (MemoryStream outStream = new MemoryStream())
            {
                BitmapEncoder enc = new BmpBitmapEncoder();
                enc.Frames.Add(BitmapFrame.Create(bitmapImage));
                enc.Save(outStream);
                System.Drawing.Bitmap bitmap = new System.Drawing.Bitmap(outStream);

                return new Bitmap(bitmap);
            }
        }

        /// <summary>
        /// bitmap 转BitmapImage
        /// </summary>
        /// <param name="bitmap"></param>
        /// <returns></returns>
        public BitmapImage BitmapToBitmapImage(System.Drawing.Bitmap bitmap)
        {
            System.Drawing.Bitmap ImageOriginalBase = new System.Drawing.Bitmap(bitmap);
            BitmapImage bitmapImage = new BitmapImage();
            using (System.IO.MemoryStream ms = new System.IO.MemoryStream())
            {
                ImageOriginalBase.Save(ms, System.Drawing.Imaging.ImageFormat.Png);
                bitmapImage.BeginInit();
                bitmapImage.StreamSource = ms;
                bitmapImage.CacheOption = BitmapCacheOption.OnLoad;
                bitmapImage.EndInit();
                bitmapImage.Freeze();
            }
            return bitmapImage;

        }



        /// <summary>
        /// ImageSource转换为Bitmap 
        /// </summary>
        /// <param name="_imagesource"></param>
        /// <returns></returns>
        public Bitmap ImageSourceToBitmap(ImageSource _imagesource)
        {
            System.IO.MemoryStream ms = new System.IO.MemoryStream();
            BmpBitmapEncoder encoder = new BmpBitmapEncoder();
            encoder.Frames.Add(BitmapFrame.Create((BitmapSource)_imagesource));
            encoder.Save(ms);
            Bitmap bp = new Bitmap(ms);
            ms.Close();
            return bp;
        }


        /// <summary>
        ///截图方法
        /// </summary>
        private void ImageCut()
        {
            isEnter = true;
            this.GetWindow()?.Close();
        }

    }
}
