﻿using Microsoft.Win32;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Service
{
    /// <summary>
    /// 注册表服务
    /// </summary>
    public class RegistryService
    {
        /// <summary>
        /// 获取Viz引擎路径
        /// </summary>
        /// <returns></returns>
        public string GetVizSetupPath()
        {
            string path = this.GetVizrtEnginePath64();
            if (!string.IsNullOrWhiteSpace(path) && System.IO.File.Exists(path))
            {
                return path;
            }

            path = this.GetVizrtEnginePath32();
            if (!string.IsNullOrWhiteSpace(path) && System.IO.File.Exists(path))
            {
                return path;
            }

            return null;
        }

        /// <summary>
        /// 获取64位Viz引擎路径
        /// </summary>
        /// <returns>64位Viz引擎路径</returns>
        private string GetVizrtEnginePath64()
        {
            RegistryKey software = Registry.LocalMachine.OpenSubKey("SOFTWARE");
            RegistryKey vizrt = software.OpenSubKey("[vizrt]");
            if (vizrt == null)
                return null;

            RegistryKey viz3 = vizrt.OpenSubKey("Viz3");
            if (viz3 == null)
                return null;

            object path = viz3.GetValue("Path");

            return path?.ToString();
        }

        /// <summary>
        /// 获取32位Viz引擎路径
        /// </summary>
        /// <returns>32位Viz引擎路径</returns>
        private string GetVizrtEnginePath32()
        {
            RegistryKey software = Registry.LocalMachine.OpenSubKey("SOFTWARE");
            RegistryKey wow = software.OpenSubKey("WOW6432Node");
            RegistryKey vizrt = wow.OpenSubKey("[vizrt]");
            if (vizrt == null)
                return null;

            RegistryKey viz3 = vizrt.OpenSubKey("Viz3");
            if (viz3 == null)
                return null;

            object path = viz3.GetValue("Path");

            return path?.ToString();
        }
    }
}
