﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 控制字段实体
    /// </summary>
    public class ControlFieldEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 所属模板ID或页ID
        /// </summary>
        public Guid PageID { get; set; }

        /// <summary>
        /// 字段名称
        /// </summary>
        public string FieldIdentifier { get; set; }

        /// <summary>
        /// 字段值
        /// </summary>
        public string Value { get; set; }

        /// <summary>
        /// 字段类型
        /// </summary>
        public VizControlFieldType Type { get; set; }

        /// <summary>
        /// 字段定义
        /// </summary>
        public string FieldDetail { get; set; }

        /// <summary>
        /// 是否是自定义字段
        /// </summary>
        public bool IsCustom { get; set; }
    }
}
