﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 控制字段节点模型
    /// </summary>
    public class ControlFieldNodeModel : ModelBase
    {
        #region Route -- 属性路由

        private List<string> route;
        /// <summary>
        /// 属性路由
        /// </summary>
        public List<string> Route
        {
            get { return route; }
            set { route = value; this.RaisePropertyChanged(nameof(Route)); }
        }

        #endregion

        #region TreeNodePath -- 树节点路径

        private string treeNodePath;
        /// <summary>
        /// 树节点路径
        /// </summary>
        public string TreeNodePath
        {
            get { return treeNodePath; }
            set { treeNodePath = value; this.RaisePropertyChanged(nameof(TreeNodePath)); }
        }

        #endregion

        #region FieldIdentifier -- 字段名称

        private string fieldIdentifier;
        /// <summary>
        /// 字段名称
        /// </summary>
        public string FieldIdentifier
        {
            get { return fieldIdentifier; }
            set { fieldIdentifier = value; this.RaisePropertyChanged(nameof(FieldIdentifier)); }
        }

        #endregion

        #region Description -- 描述

        private string description;
        /// <summary>
        /// 描述
        /// </summary>
        public string Description
        {
            get { return description; }
            set { description = value; this.RaisePropertyChanged(nameof(Description)); }
        }

        #endregion

        #region Value -- 字段值

        private string _value;
        /// <summary>
        /// 字段值
        /// </summary>
        public string Value
        {
            get { return _value; }
            set { _value = value; this.RaisePropertyChanged(nameof(Value)); }
        }

        #endregion

        #region Type -- 字段类型

        private VizControlFieldType type;
        /// <summary>
        /// 字段类型
        /// </summary>
        public VizControlFieldType Type
        {
            get { return type; }
            set { type = value; this.RaisePropertyChanged(nameof(Type)); }
        }

        #endregion

        #region TypeSchema -- 字段类型定义

        private string typeSchema;
        /// <summary>
        /// 字段类型定义
        /// </summary>
        public string TypeSchema
        {
            get { return typeSchema; }
            set { typeSchema = value; this.RaisePropertyChanged(nameof(TypeSchema)); }
        }

        #endregion

        #region Items -- 子节点集合

        private List<ControlFieldNodeModel> items = new List<ControlFieldNodeModel>();
        /// <summary>
        /// 子节点集合
        /// </summary>
        public List<ControlFieldNodeModel> Items
        {
            get { return items; }
            set { items = value; this.RaisePropertyChanged(nameof(Items)); }
        }

        #endregion
    }
}
