﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 页模型
    /// </summary>
    public class PageModel : PageModelBase
    {
        #region PageID -- 页ID

        private Guid pageID;
        /// <summary>
        /// 页ID
        /// </summary>
        public Guid PageID
        {
            get { return pageID; }
            set { pageID = value; this.RaisePropertyChanged(nameof(PageID)); }
        }

        #endregion

        #region PageGroupID -- 所属页分组ID

        private Guid pageGroupID;
        /// <summary>
        /// 所属页分组ID
        /// </summary>
        public Guid PageGroupID
        {
            get { return pageGroupID; }
            set { pageGroupID = value; this.RaisePropertyChanged(nameof(PageGroupID)); }
        }

        #endregion

        #region TemplateID -- 模板ID

        private Guid templateID;
        /// <summary>
        /// 模板ID
        /// </summary>
        public Guid TemplateID
        {
            get { return templateID; }
            set { templateID = value; this.RaisePropertyChanged(nameof(TemplateID)); }
        }

        #endregion

        #region PluginID -- 插件ID

        private string pluginID;
        /// <summary>
        /// 插件ID
        /// </summary>
        public string PluginID
        {
            get { return pluginID; }
            set { pluginID = value; this.RaisePropertyChanged(nameof(PluginID)); }
        }

        #endregion
    }
}
