﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 编辑面板模型基类
    /// </summary>
    public abstract class EditPanelModelBase : ViewModelBase
    {

        // ============================================================
        // Service & Controller
        // ============================================================

        /// <summary>
        /// Viz 控制对象服务
        /// </summary>
        protected VizCommandControlObjectService VizCommandControlObjectService = new VizCommandControlObjectService();

        // ============================================================
        // Property
        // ============================================================

        #region IsSendToPreview -- 是否向预览发送命令

        private bool isSendToPreview;
        /// <summary>
        /// 是否向预览发送命令
        /// </summary>
        public bool IsSendToPreview
        {
            get { return isSendToPreview; }
            set { isSendToPreview = value; this.RaisePropertyChanged(nameof(IsSendToPreview)); }
        }

        #endregion

        #region ControlObject -- 控制对象

        private ControlObjectModel controlObject;
        /// <summary>
        /// 控制对象
        /// </summary>
        public ControlObjectModel ControlObject
        {
            get { return controlObject; }
            set { controlObject = value; this.RaisePropertyChanged(nameof(ControlObject)); }
        }

        #endregion

        #region ControlField -- 所属控制字段

        private ControlFieldNodeModel controlField;
        /// <summary>
        /// 所属控制字段
        /// </summary>
        public ControlFieldNodeModel ControlField
        {
            get { return controlField; }
            set { controlField = value; this.RaisePropertyChanged(nameof(ControlField)); }
        }

        #endregion

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="controlObject">控制对象</param>
        /// <param name="controlField">控制字段</param>
        public virtual void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            this.ControlObject = controlObject;
            this.ControlField = controlField;

            this.IsSendToPreview = true;
        }
    }
}
