﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 图片编辑面板模型
    /// </summary>
    public class ImageEditPanelModel : ResourceEditPanelModelBase
    {
        public ImageEditPanelModel()
        {
            this.GHResourceEditPartModel.FilterResourceFileType = ResourceFileType.IMAGE;
            this.GHResourceEditPartModel.OnSelectedFileModelChanged += GHResourceEditPartModel_OnSelectedFileModelChanged;

            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.OpenLocalFileCommand = new VCommand(this.OpenLocalFile);
        }

        // =====================================================================
        // Field
        // =====================================================================

        /// <summary>
        /// Viz资源图片筛选器
        /// </summary>
        private string VIZ_IMAGE_FILTER = ApplicationDomainEx.IniStorage.GetValue<VizConfig, string>(p => p.VIZ_IMAGE_FILTER);

        // =====================================================================
        // Property
        // =====================================================================

        #region Path -- 路径

        private string path;
        /// <summary>
        /// 路径
        /// </summary>
        public string Path
        {
            get { return path; }
            set
            {
                path = value;
                this.RaisePropertyChanged(nameof(Path));
                this.OnPathChanged();
            }
        }

        #endregion

        // =====================================================================
        // Command
        // =====================================================================

        #region OpenLocalFileCommand -- 打开本地文件命令

        /// <summary>
        /// 打开本地文件命令
        /// </summary>
        public VCommand OpenLocalFileCommand { get; set; }

        /// <summary>
        /// 打开本地文件
        /// </summary>
        private void OpenLocalFile()
        {
            System.Windows.Forms.OpenFileDialog ofd = new System.Windows.Forms.OpenFileDialog();
            ofd.Filter = VIZ_IMAGE_FILTER;
            ofd.Multiselect = false;
            if (ofd.ShowDialog() != System.Windows.Forms.DialogResult.OK)
                return;

            this.IsSendToPreview = false;
            this.GHResourceEditPartModel.SelectedFileModel = null;
            this.IsSendToPreview = true;
            this.Path = ofd.FileName;
        }

        #endregion

        // =====================================================================
        // Public Function
        // =====================================================================

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="controlObject">控制对象</param>
        /// <param name="controlField">控制字段</param>
        public override void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            base.Update(controlObject, controlField);

            this.Path = controlField?.Value;
        }

        // =====================================================================
        // Private Function
        // =====================================================================

        /// <summary>
        /// 路径切换时触发
        /// </summary>
        private void OnPathChanged()
        {
            // 不需要向预览发送值
            if (!this.IsSendToPreview)
                return;

            // 没有预览连接
            if (ApplicationDomainEx.PreviewConn == null)
                return;

            // 没有控制对象或控制字段
            if (this.ControlObject == null || this.ControlField == null)
                return;

            this.ControlField.Value = this.Path;

            this.VizCommandControlObjectService.SetControlObjectValue(
                ApplicationDomainEx.PreviewConn,
                this.ControlObject.TreeNodePath,
                this.ControlField.FieldIdentifier,
                this.ControlField.Value);
        }

        /// <summary>
        /// GH库文件选择改变时触发
        /// </summary>
        private void GHResourceEditPartModel_OnSelectedFileModelChanged(object sender, GHResourceSelectedFileChangedEventArgs e)
        {
            if (e.File == null || string.IsNullOrWhiteSpace(e.File.ResourcePath))
                return;

            this.Path = e.File?.ResourcePath;
        }
    }
}
