﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 列表编辑面板列定义
    /// </summary>
    public class ListEditPanelColumnDefinition
    {
        /// <summary>
        /// 绑定字段
        /// </summary>
        public string FieldName { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public GridColumnWidth Width { get; set; } = new GridColumnWidth(1, GridColumnUnitType.Star);

        /// <summary>
        /// 最小宽度
        /// </summary>
        public double MinWidth { get; set; } = 120;

        /// <summary>
        /// 头部
        /// </summary>
        public object Header { get; set; }

        /// <summary>
        /// 是否只读
        /// </summary>
        public bool ReadOnly { get; set; }
    }
}
