﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 文本编辑面板模型
    /// </summary>
    public class TextEditPanelModel : EditPanelModelBase
    {
        // ============================================================
        // Property
        // ============================================================

        #region Text -- 文本

        private string text;
        /// <summary>
        /// 文本
        /// </summary>
        public string Text
        {
            get { return text; }
            set
            {
                text = value;
                this.RaisePropertyChanged(nameof(Text));
                this.OnTextChanged();
            }
        }

        #endregion

        // ============================================================
        // Message
        // ============================================================

        // ============================================================
        // Public Function
        // ============================================================

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="controlObject">控制对象</param>
        /// <param name="controlField">控制字段</param>
        public override void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            base.Update(controlObject, controlField);

            this.IsSendToPreview = false;
            this.Text = controlField?.Value;
            this.IsSendToPreview = true;
        }

        // ============================================================
        // Private Function
        // ============================================================

        /// <summary>
        /// 文本值改变时触发
        /// </summary>
        private void OnTextChanged()
        {
            // 不需要向预览发送值
            if (!this.IsSendToPreview)
                return;

            // 没有预览连接
            if (ApplicationDomainEx.PreviewConn == null)
                return;

            // 没有控制对象或控制字段
            if (this.ControlObject == null || this.ControlField == null)
                return;

            this.ControlField.Value = this.Text;

            this.VizCommandControlObjectService.SetControlObjectValue(
                ApplicationDomainEx.PreviewConn,
                this.ControlObject.TreeNodePath,
                this.ControlField.FieldIdentifier,
                this.ControlField.Value);
        }
    }
}
