﻿using DevExpress.Xpf.Grid.TreeList;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 字段树视图模型
    /// </summary>
    public class FieldTreeViewModel : ViewModelBase
    {
        public FieldTreeViewModel()
        {
            // 初始化命令
            this.InitCommand();

            // 初始化消息
            this.InitMessage();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.ExpandingCommand = new VCommand<TreeListNodeAllowEventArgs>(this.Expanding);
        }

        /// <summary>
        /// 初始化消息
        /// </summary>
        private void InitMessage()
        {
            ApplicationDomainEx.MessageManager.Register<PageInitedMessage>(this, this.OnPageInitedMessage);
        }

        // =============================================================
        // Service & Controller
        // =============================================================

        /// <summary>
        /// Viz 控制对象命令服务
        /// </summary>
        private VizCommandControlObjectService vizCommandControlObjectService = new VizCommandControlObjectService();

        // =============================================================
        // Property
        // =============================================================

        #region IsLoading -- 是否正在加载

        private bool isLoading;
        /// <summary>
        /// 是否正在加载
        /// </summary>
        public bool IsLoading
        {
            get { return isLoading; }
            set { isLoading = value; this.RaisePropertyChanged(nameof(IsLoading)); }
        }

        #endregion

        #region ControlObject -- 控制对象

        private ControlObjectModel controlObject;
        /// <summary>
        /// 控制对象
        /// </summary>
        public ControlObjectModel ControlObject
        {
            get { return controlObject; }
            set { controlObject = value; this.RaisePropertyChanged(nameof(ControlObject)); }
        }

        #endregion

        #region SelectedControlField -- 当前选中的控制字段

        private ControlFieldNodeModel selectedControlField;
        /// <summary>
        /// 当前选中的控制字段
        /// </summary>
        public ControlFieldNodeModel SelectedControlField
        {
            get { return selectedControlField; }
            set
            {
                selectedControlField = value;
                this.RaisePropertyChanged(nameof(SelectedControlField));

                // 发送切换消息
                ControlFieldChangedMessage msg = new ControlFieldChangedMessage();
                msg.ControlObject = this.ControlObject;
                msg.ControlField = value;

                ApplicationDomainEx.MessageManager.Send(msg);
            }
        }

        #endregion

        // =============================================================
        // Command
        // =============================================================

        #region ExpandingCommand -- 展开前命令

        /// <summary>
        /// 展开节点命令
        /// </summary>
        public VCommand<TreeListNodeAllowEventArgs> ExpandingCommand { get; set; }

        /// <summary>
        /// 展开节点
        /// </summary>
        /// <param name="e"></param>
        private void Expanding(TreeListNodeAllowEventArgs e)
        {

        }

        #endregion

        // =============================================================
        // Message
        // =============================================================

        /// <summary>
        /// 页初始化完成消息
        /// </summary>
        /// <param name="msg">消息</param>
        private void OnPageInitedMessage(PageInitedMessage msg)
        {
            this.IsLoading = true;

            ThreadHelper.SafeRun(action: () =>
            {
                ControlObjectModel controlObject = this.vizCommandControlObjectService.GetControlObject(ApplicationDomainEx.PreviewConn);

                WPFHelper.BeginInvoke(() =>
                {
                    this.ControlObject = controlObject;
                });
            }, final: () =>
            {
                WPFHelper.BeginInvoke(() =>
                {
                    this.IsLoading = false;
                });
            });
        }
    }
}