﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Plugin;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 主视图模型
    /// </summary>
    public class MainViewModel : ViewModelBase, IMainViewService
    {
        public MainViewModel()
        {
            ApplicationDomainEx.ServiceManager.AddService(ViewServiceKeys.MAIN_VIEW_SERVICE, this);

            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
        }

        // ============================================================
        // Service & Controller
        // ============================================================

        // ============================================================
        // Property
        // ============================================================

        #region ItemsSource -- 视图项

        private ObservableCollection<PluginInfo> itemsSource = ApplicationDomainEx.PluginInfos.Where(p => p.PluginType == PluginType.Module).ToObservableCollection();
        /// <summary>
        /// 视图项
        /// </summary>
        public ObservableCollection<PluginInfo> ItemsSource
        {
            get { return itemsSource; }
            set { itemsSource = value; this.RaisePropertyChanged(nameof(ItemsSource)); }
        }

        #endregion

        // ============================================================
        // Command
        // ============================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            if (this.IsAlreadyLoaded)
                return;

            this.IsAlreadyLoaded = true;

            this.LoadLayout();
        }

        #endregion

        // ============================================================
        // Public Function
        // ============================================================

        /// <summary>
        /// 保存布局
        /// </summary>
        public void SaveLayout()
        {
            MainView view = this.GetView<MainView>();
            if (view == null)
                return;

            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "layout.xml");
            view.dockLayoutManager.SaveLayoutToXml(path);
        }

        /// <summary>
        /// 加载布局
        /// </summary>
        public void LoadLayout()
        {
            MainView view = this.GetView<MainView>();
            if (view == null)
                return;

            string path = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "layout.xml");
            view.dockLayoutManager.RestoreLayoutFromXml(path);
        }
    }
}
