﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 连接实体
    /// </summary>
    public class ConnEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 连接ID
        /// </summary>
        public Guid ConnID { get; set; }

        /// <summary>
        /// 分组ID
        /// </summary>
        public Guid GroupID { get; set; }

        /// <summary>
        /// IP地址
        /// </summary>
        public string IP { get; set; }

        /// <summary>
        /// 端口
        /// </summary>
        public int Port { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 引擎类型
        /// </summary>
        public EngineType EngineType { get; set; }

        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled { get; set; }
    }
}
