﻿using LiteDB;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 本地数据上下文
    /// </summary>
    public class LocalDbContext
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(LocalDbContext));

        /// <summary>
        /// 数据库
        /// </summary>
        private ILiteDatabase Database;

        /// <summary>
        /// LiteDB数据库
        /// </summary>
        /// <param name="path">数据库路径</param>
        public LocalDbContext(string path)
        {
            this.Path = path;

            this.Database = new LiteDatabase(path);

            this.VizConfig = this.Database.GetCollection<VizConfigEntity>();
            this.ConnGroup = this.Database.GetCollection<ConnGroupEntity>();
            this.Conn = this.Database.GetCollection<ConnEntity>();
        }

        /// <summary>
        /// 数据库文件路径
        /// </summary>
        public string Path { get; private set; }

        /// <summary>
        /// Viz配置
        /// </summary>
        public ILiteCollection<VizConfigEntity> VizConfig { get; private set; }

        /// <summary>
        /// 连接分组
        /// </summary>
        public ILiteCollection<ConnGroupEntity> ConnGroup { get; private set; }

        /// <summary>
        /// 连接
        /// </summary>
        public ILiteCollection<ConnEntity> Conn { get; private set; }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.VizConfig = null;
            this.ConnGroup = null;
            this.Conn = null;

            this.Database?.Dispose();
        }
    }
}