﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// GH 节点辅助类
    /// </summary>
    public static class GH_NodeHelper
    {
        /// <summary>
        /// 从XML中获取Feed节点
        /// </summary>
        /// <param name="xml">xml数据</param>
        /// <returns>Feed节点</returns>
        public static GH_Feed_Node CreateFeedFromXML(string xml)
        {
            byte[] buffer = Encoding.UTF8.GetBytes(xml);
            using (System.IO.MemoryStream ms = new System.IO.MemoryStream(buffer))
            {
                XElement feed = XElement.Load(ms);

                GH_Feed_Node feed_node = new GH_Feed_Node();
                feed_node.FromXmlElement(feed);

                return feed_node;
            }
        }
    }
}
