﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using VIZ.Package.Domain;
using VIZ.Package.Domain.Model;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 主视图菜单模板选择器
    /// </summary>
    public class MainTopViewMenuDataTemplateSelector : DataTemplateSelector
    {
        /// <summary>
        /// 勾选框数据模型
        /// </summary>
        public DataTemplate CheckBoxDataTemplate { get; set; }

        /// <summary>
        /// 按钮数据模板
        /// </summary>
        public DataTemplate ButtonDataTemplate { get; set; }

        /// <summary>
        /// 分隔线数据模板
        /// </summary>
        public DataTemplate SeparatorTemplate { get; set; }

        /// <summary>
        /// 选择模板
        /// </summary>
        /// <returns></returns>
        public override DataTemplate SelectTemplate(object item, DependencyObject container)
        {
            MenuItemModel model = item as MenuItemModel;
            if (model == null)
                return null;

            switch (model.Type)
            {
                case MenuItemType.Button: return this.ButtonDataTemplate;
                case MenuItemType.CheckBox: return this.CheckBoxDataTemplate;
                case MenuItemType.Separator: return this.SeparatorTemplate;
            }

            return null;
        }
    }
}
