﻿using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    public class CreateFolderViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static readonly ILog log = LogManager.GetLogger(typeof(CreateFolderViewModel));

        /// <summary>
        /// 初始化
        /// </summary>
        public CreateFolderViewModel()
        {
            EnterCommand = new VCommand(Enter);
            CancelCommand = new VCommand(Cancel);
        }

        private string folderName;

        /// <summary>
        /// 文件夹名称
        /// </summary>
        public string FolderName
        {
            get { return folderName; }
            set { folderName = value; this.RaisePropertyChanged(nameof(FolderName)); }
        }





        private bool isEnter;
        /// <summary>
        /// 是否确定
        /// </summary>
        public bool IsEnter
        {
            get { return isEnter; }
            set { isEnter = value; this.RaisePropertyChanged(nameof(IsEnter)); }
        }

        public VCommand EnterCommand { get; set; }

        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            if (string.IsNullOrWhiteSpace(this.FolderName))
            {
                DXMessageBox.Show("请输入文件名");
                return;
            }
            this.IsEnter = true;
            this.GetWindow()?.Close();
        }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            this.IsEnter = false;
            this.GetWindow()?.Close();
        }
    }
}
