﻿using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 热键设置视图模型
    /// </summary>
    public class HotKeySettingViewModel : ViewModelBase
    {
        public HotKeySettingViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
        }


        // ======================================================================================
        // Field
        // ======================================================================================

        /// <summary>
        /// 是否正在进行热键检测
        /// </summary>
        private bool isInHotkeyCheck;

        // ======================================================================================
        // Property
        // ======================================================================================

        #region Take -- 上板

        private string take;
        /// <summary>
        /// 上板
        /// </summary>
        public string Take
        {
            get { return take; }
            set
            {
                this.CheckHotkey(value);
                take = value;
                this.RaisePropertyChanged(nameof(Take));
            }
        }

        #endregion

        #region TakeContinue -- 上板继续

        private string takeContinue;
        /// <summary>
        /// 上板继续
        /// </summary>
        public string TakeContinue
        {
            get { return takeContinue; }
            set
            {
                this.CheckHotkey(value);
                takeContinue = value;
                this.RaisePropertyChanged(nameof(TakeContinue));
            }
        }

        #endregion

        #region TakeOut -- 下版子

        private string takeOut;
        /// <summary>
        /// 下版子
        /// </summary>
        public string TakeOut
        {
            get { return takeOut; }
            set
            {
                this.CheckHotkey(value);
                takeOut = value;
                this.RaisePropertyChanged(nameof(TakeOut));
            }
        }

        #endregion

        #region TakeUpdate -- 上板更新

        private string takeUpdate;
        /// <summary>
        /// 上板更新
        /// </summary>
        public string TakeUpdate
        {
            get { return takeUpdate; }
            set
            {
                this.CheckHotkey(value);
                takeUpdate = value;
                this.RaisePropertyChanged(nameof(TakeUpdate));
            }
        }

        #endregion

        #region OpenNextPage -- 打开下一页

        private string openNextPage;
        /// <summary>
        /// 打开下一页
        /// </summary>
        public string OpenNextPage
        {
            get { return openNextPage; }
            set
            {
                this.CheckHotkey(value);
                openNextPage = value;
                this.RaisePropertyChanged(nameof(OpenNextPage));
            }
        }

        #endregion

        #region SaveOpendPageOrTemplateAndProject -- 保存当前打开的页或模板和项目

        private string saveOpendPageOrTemplateAndProject;
        /// <summary>
        /// 保存当前打开的页或模板和项目
        /// </summary>
        public string SaveOpendPageOrTemplateAndProject
        {
            get { return saveOpendPageOrTemplateAndProject; }
            set
            {
                this.CheckHotkey(value);
                saveOpendPageOrTemplateAndProject = value;
                this.RaisePropertyChanged(nameof(SaveOpendPageOrTemplateAndProject));
            }
        }

        #endregion

        // ======================================================================================
        // Command
        // ======================================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            HotKeyConfigEntity config = ApplicationDomainEx.HotKeyConfig;

            this.Take = config.Take;
            this.TakeContinue = config.TakeContinue;
            this.TakeOut = config.TakeOut;
            this.TakeUpdate = config.TakeUpdate;
            this.OpenNextPage = config.OpenNextPage;
            this.SaveOpendPageOrTemplateAndProject = config.SaveOpendPageOrTemplateAndProject;
        }

        #endregion

        // ======================================================================================
        // Public Function
        // ======================================================================================

        /// <summary>
        /// 保存
        /// </summary>
        public void Save()
        {
            HotKeyConfigEntity config = ApplicationDomainEx.HotKeyConfig;

            config.Take = this.Take;
            config.TakeContinue = this.TakeContinue;
            config.TakeOut = this.TakeOut;
            config.TakeUpdate = this.TakeUpdate;
            config.OpenNextPage = this.OpenNextPage;
            config.SaveOpendPageOrTemplateAndProject = this.SaveOpendPageOrTemplateAndProject;

            ApplicationDomainEx.LocalDbContext.HotKeyConfig.Update(config);
        }

        // ======================================================================================
        // Private Function
        // ======================================================================================

        /// <summary>
        /// 检测热键
        /// </summary>
        /// <param name="key">热键</param>
        private void CheckHotkey(string key)
        {
            if (this.isInHotkeyCheck)
                return;

            this.isInHotkeyCheck = true;

            if (string.Equals(this.Take, key))
            {
                this.Take = string.Empty;
            }
            if (string.Equals(this.TakeContinue, key))
            {
                this.TakeContinue = string.Empty;
            }
            if (string.Equals(this.TakeOut, key))
            {
                this.TakeOut = string.Empty;
            }
            if (string.Equals(this.TakeUpdate, key))
            {
                this.TakeUpdate = string.Empty;
            }
            if (string.Equals(this.OpenNextPage, key))
            {
                this.OpenNextPage = string.Empty;
            }
            if (string.Equals(this.SaveOpendPageOrTemplateAndProject, key))
            {
                this.SaveOpendPageOrTemplateAndProject = string.Empty;
            }

            this.isInHotkeyCheck = false;
        }
    }
}
