﻿using CsvHelper.Configuration.Attributes;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 操作日志
    /// </summary>
    public class RecordLog
    {
        public static int ALL_ID = 0;

        /// <summary>
        /// 编号
        /// </summary>
        [Name("编号")]
        public int ID { get; set; }

        /// <summary>
        /// 时间
        /// </summary>
        [Name("时间")]
        [Format("yyyy-MM-dd HH:mm:ss")]
        public DateTime DateTime { get; set; }

        /// <summary>
        /// 插件
        /// </summary>
        [Name("插件")]
        public string Plugin { get; set; }

        /// <summary>
        /// 日志类型
        /// </summary>
        /// <see cref="RecordLogOperate"/>
        [Name("日志类型")]
        public string Operate { get; set; }

        /// <summary>
        /// 触发方式
        /// </summary>
        /// <see cref="RecordLogTrigger"/>
        [Name("触发方式")]
        public string Trigger { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        [Name("描述")]
        public string Detail { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        [Name("备注")]
        public string Remark { get; set; }
    }
}
