﻿using log4net.Appender;
using log4net.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;

namespace VIZ.Package.Common
{
    /// <summary>
    /// 错误消息附加
    /// </summary>
    public class ErrorMessageAppender : IAppender
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; } = "ErrorMessageAppender";

        /// <summary>
        /// 关闭
        /// </summary>
        public void Close()
        {
            // nothing to do.
        }

        /// <summary>
        /// 执行
        /// </summary>
        /// <param name="loggingEvent">日志事件</param>
        public void DoAppend(LoggingEvent loggingEvent)
        {
            try
            {
                if (loggingEvent.Level != Level.Error)
                    return;

                ErrorLogMessage msg = new ErrorLogMessage();
                msg.Error = loggingEvent.RenderedMessage;

                Task.Run(() =>
                {
                    ApplicationDomainEx.MessageManager.Send(msg);
                });
            }
            catch
            {
                // nothing can do.
            }
        }
    }
}
