﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 页模型扩展
    /// </summary>
    public static class PageModelExpand
    {
        /// <summary>
        /// 获取场景信息
        /// </summary>
        /// <param name="pageBase">页模型基类</param>
        /// <returns>场景信息</returns>
        public static SceneInfoModel GetSceneInfo(this PageModelBase pageBase)
        {
            if (pageBase is PageModel page)
            {
                return page.SceneInfo;
            }
            else if (pageBase is PageTemplateModel template)
            {
                return ApplicationDomainEx.GetSceneInfo(template);
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// 获取场景父级
        /// </summary>
        /// <param name="pageBase">页模型基类</param>
        /// <returns>场景父级</returns>
        public static string GetSceneParent(this PageModelBase pageBase)
        {
            string parent = pageBase.ScenePath.Substring(0, pageBase.ScenePath.LastIndexOf('/'));
            return parent;
        }

        /// <summary>
        /// 获取模板ID或页ID
        /// </summary>
        /// <param name="pageBase">页模型基类</param>
        /// <returns>模板ID或页ID</returns>
        public static Guid GetTemplateIdOrPageId(this PageModelBase pageBase)
        {
            if (pageBase is PageModel page)
                return page.PageID;

            if (pageBase is PageTemplateModel template)
                return template.TemplateID;

            return Guid.Empty;
        }

        /// <summary>
        /// 获取Viz场景层
        /// </summary>
        /// <param name="pageBase">页模型基类</param>
        /// <returns>Viz场景层</returns>
        public static VizScene GetVizScene(this PageModelBase pageBase)
        {
            if (pageBase == null)
                return VizScene.MAIN_SCENE;

            switch (pageBase.Layer)
            {
                case VizLayer.FRONT_LAYER: return VizScene.FRONT_SCENE;
                case VizLayer.MAIN_LAYER: return VizScene.MAIN_SCENE;
                case VizLayer.BACK_LAYER: return VizScene.BACK_SCENE;
                default: return VizScene.MAIN_SCENE;
            }
        }
    }
}
