﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 插件信息
    /// </summary>
    public class PluginInfo : ModelBase
    {
        #region ID -- 插件ID

        private string id;
        /// <summary>
        /// 插件ID
        /// </summary>
        public string ID
        {
            get { return id; }
            set { id = value; this.RaisePropertyChanged(nameof(ID)); }
        }

        #endregion

        #region Group -- 分组

        private string group;
        /// <summary>
        /// 分组
        /// </summary>
        public string Group
        {
            get { return group; }
            set { group = value; this.RaisePropertyChanged(nameof(Group)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region Icon -- 图标

        private string icon;
        /// <summary>
        /// 图标
        /// </summary>
        public string Icon
        {
            get { return icon; }
            set { icon = value; this.RaisePropertyChanged(nameof(Icon)); }
        }

        #endregion

        #region ViewType -- 视图类型

        private Type viewType;
        /// <summary>
        /// 视图类型
        /// </summary>
        public Type ViewType
        {
            get { return viewType; }
            set { viewType = value; this.RaisePropertyChanged(nameof(ViewType)); }
        }

        #endregion

        #region PluginType -- 插件类型

        private PluginType pluginType;
        /// <summary>
        /// 插件类型
        /// </summary>
        public PluginType PluginType
        {
            get { return pluginType; }
            set { pluginType = value; this.RaisePropertyChanged(nameof(PluginType)); }
        }

        #endregion

        #region IsClosed -- 是否关闭

        private bool isClosed;
        /// <summary>
        /// 是否显示
        /// </summary>
        public bool IsClosed
        {
            get { return isClosed; }
            set { isClosed = value; this.RaisePropertyChanged(nameof(IsClosed)); }
        }

        #endregion

        #region View -- 视图

        private WeakReference<FrameworkElement> view;
        /// <summary>
        /// 视图
        /// </summary>
        public WeakReference<FrameworkElement> View
        {
            get { return view; }
            set { view = value; this.RaisePropertyChanged(nameof(View)); }
        }

        #endregion

        /// <summary>
        /// 空插件
        /// </summary>
        public static PluginInfo NONE { get; } = new PluginInfo();
    }
}
