﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Media;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    public class ColorEditPanelModel : EditPanelModelBase
    {
        public override string GetFieldValue()
        {
            return fieldValue;
        }

        public ColorEditPanelModel()
        {
            InitCommand();
        }

        /// <summary>
        /// 初始化方法
        /// </summary>
        private void InitCommand()
        {
            this.AmbCommand = new VCommand(AmbCmd);
            this.DiffCommand = new VCommand(DiffCmd);
            this.SpecCommand = new VCommand(SpecCmd);
            this.EmisCommand = new VCommand(EmisCmd);
        }

        /// <summary>
        /// 绑定color颜色
        /// </summary>
        private Color colorValue;

        public Color ColorValue
        {
            get { return colorValue; }
            set
            {
                colorValue = value;
                this.RaisePropertyChanged(nameof(ColorValue));

                if (IsEnabledAll)
                {
                    if (IsEnabledA == false)
                    {
                        ambientColor = colorValue;
                    }
                    else if (IsEnabledD == false)
                    {
                        diffuseColor = colorValue;
                    }
                    else if (IsEnabledS == false)
                    {
                        specularColor = colorValue;
                    }
                    else if (IsEnabledE == false)
                    {
                        emissionColor = colorValue;
                    }

                    SendColorValue();
                }
                else 
                {
                    eColor = colorValue;
                    SendIsEnbaleAll();
                }
            }
        }

        /// <summary>
        /// ambientColor 设置颜色缓存
        /// </summary>
        private Color ambientColor;

        /// <summary>
        /// diffuseColor 设置颜色缓存
        /// </summary>
        private Color diffuseColor;

        /// <summary>
        /// specularColor 设置颜色缓存
        /// </summary>
        private Color specularColor;

        /// <summary>
        /// emissionColor 设置颜色缓存
        /// </summary>
        private Color emissionColor;

        /// <summary>
        /// 按钮禁用后 设置Color颜色缓存
        /// </summary>
        private Color eColor;

        //设置字段后的字符串
        private string fieldValue = "";

        /// <summary>
        /// 是否Ambient是否被禁用
        /// </summary>
        private bool isEnabledA = false;

        public bool IsEnabledA
        {
            get { return isEnabledA; }
            set
            {
                isEnabledA = value;
                this.RaisePropertyChanged(nameof(IsEnabledA));

                if(isEnabledA==false)
                {
                    ColorValue = ambientColor;
                }
            }
        }

        /// <summary>
        /// Diffuse 是否禁用
        /// </summary>
        private bool isEnabledD = true;

        public bool IsEnabledD
        {
            get { return isEnabledD; }
            set
            {
                isEnabledD = value;
                this.RaisePropertyChanged(nameof(IsEnabledD));

                if(IsEnabledD==false)
                {
                    ColorValue = diffuseColor;
                }
            }
        }

        /// <summary>
        /// Specular 是否被禁用
        /// </summary>
        private bool isEnabledS = true;

        public bool IsEnabledS
        {
            get { return isEnabledS; }
            set
            {
                isEnabledS = value;
                this.RaisePropertyChanged(nameof(IsEnabledS));

                if(IsEnabledS==false)
                {
                    ColorValue = specularColor;
                }
            }
        }


        /// <summary>
        /// Emission 是否被禁用
        /// </summary>
        private bool isEnabledE = true;

        public bool IsEnabledE
        {
            get { return isEnabledE; }
            set
            {
                isEnabledE = value;
                this.RaisePropertyChanged(nameof(IsEnabledE));

                if(isEnabledE==false)
                {
                    ColorValue = emissionColor;
                }
            }
        }


        /// <summary>
        /// E 是否禁用
        /// </summary>

        private bool isEnabledAll = true;

        public bool IsEnabledAll
        {
            get { return isEnabledAll; }

            set
            {
                isEnabledAll = value;
                this.RaisePropertyChanged(nameof(IsEnabledAll));

                if (isEnabledAll)
                {
                    BtnGroupEnable = true;

                    if (IsEnabledA == false)
                    {
                        ColorValue = ambientColor;
                    }
                    else if (IsEnabledD == false)
                    {
                        ColorValue = diffuseColor;
                    }
                    else if (IsEnabledS == false)
                    {
                        ColorValue = specularColor;
                    }
                    else if (IsEnabledE == false)
                    {
                        ColorValue = emissionColor;
                    }
                    else if (IsEnabledAll == false)
                    {
                        ColorValue = eColor;
                    }

                    SendColorValue();

                }
                else
                {
                    BtnGroupEnable = false;
                    ColorValue = eColor;

                    SendIsEnbaleAll();

                }
            }
        }

        /// <summary>
        /// BtnGroupEnable 是否禁用-
        /// 
        /// </summary>
        private bool btnGroupEnable=true;

        public bool BtnGroupEnable
        {
            get { return btnGroupEnable; }
            set
            { 
                btnGroupEnable = value;
                this.RaisePropertyChanged(nameof(BtnGroupEnable));

            }
        }

        /// <summary>
        ///  shininess类型
        /// </summary>
        private double shininess;

        public double Shininess
        {
            get { return shininess; }

            set
            {
                shininess = value;
                this.RaisePropertyChanged(nameof(Shininess));

                if (isEnabledAll)
                {
                    SendColorValue();
                }
                else
                {
                    SendIsEnbaleAll();
                }

            }
        }


        /// <summary>
        /// alpha类型
        /// </summary>
        private double alpha;
        public double Alpha
        {
            get { return alpha; }
            set
            {
                alpha = value;
                this.RaisePropertyChanged(nameof(Alpha));


                if (isEnabledAll)
                {
                    SendColorValue();
                }
                else
                {
                    SendIsEnbaleAll();
                }


            }
        }

        /// <summary>
        ///第一次保存以后，打开更新的值到对象里面
        /// </summary>
        /// <param name="controlObject"></param>
        /// <param name="controlField"></param>

        public override void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            base.Update(controlObject, controlField);

            //this.IsSendToPreview = false;
            //this.IsSendToPreview = true;


           if(string.IsNullOrEmpty(this.ControlField.Value))
           {
                return;
           }
           else
           {
                string[] strValue = controlField.Value.Split(';');

                Shininess = Convert.ToDouble(strValue[1]);
                Alpha =Convert.ToDouble(strValue[2]);

                if (strValue[0]=="0")
                {
                    string[] colorValue = strValue[3].Split(',');

                    // Color 颜色 R,G,B,A 
                    eColor = Color.FromArgb(Convert.ToByte(Convert.ToDouble(colorValue[3])*255), Convert.ToByte(Convert.ToDouble(colorValue[0])*255),
                       Convert.ToByte(Convert.ToDouble(colorValue[1])*255), Convert.ToByte(Convert.ToDouble(colorValue[2])*255));
                    ColorValue = eColor;
                    IsEnabledAll = false;

                }
                else
                {
                    IsEnabledAll = true;
                   //Ambient   返回数组R,G,B,A
                   string[] strAmbient = strValue[3].Split(',');
                    ambientColor = Color.FromArgb(Convert.ToByte(Convert.ToDouble(strAmbient[3])*255), Convert.ToByte(Convert.ToDouble(strAmbient[0])*255),
                        Convert.ToByte(Convert.ToDouble(strAmbient[1])*255), Convert.ToByte(Convert.ToDouble(strAmbient[2])*255));

                    //Diffuse  返回数组R,G,B,A
                    string[] strDiffuse = strValue[4].Split(',');
                    diffuseColor = Color.FromArgb(Convert.ToByte(Convert.ToDouble(strDiffuse[3])*255), Convert.ToByte(Convert.ToDouble(strDiffuse[0])*255),
                        Convert.ToByte(Convert.ToDouble(strDiffuse[1])*255), Convert.ToByte(Convert.ToDouble(strDiffuse[2])*255));

                    //Specular 返回数组R,G,B,A
                    string[] strSpecular = strValue[5].Split(',');
                    specularColor= Color.FromArgb(Convert.ToByte(Convert.ToDouble(strSpecular[3])*255), Convert.ToByte(Convert.ToDouble(strSpecular[0])*255),
                        Convert.ToByte(Convert.ToDouble(strSpecular[1])*255), Convert.ToByte(Convert.ToDouble(strSpecular[2])*255));

                    //Emission 返回数组R,G,B,A
                    string[] strEmission = strValue[6].Split(',');
                    emissionColor = Color.FromArgb(Convert.ToByte(Convert.ToDouble(strEmission[3])*255), Convert.ToByte(Convert.ToDouble(strEmission[0])*255),
                       Convert.ToByte(Convert.ToDouble(strEmission[1])*255), Convert.ToByte(Convert.ToDouble(strEmission[2])*255));

                    if (IsEnabledA == false)
                    {
                        ColorValue = ambientColor;
                    }
                    else if (IsEnabledD == false)
                    {
                        ColorValue = diffuseColor;
                    }
                    else if (IsEnabledS == false)
                    {
                        ColorValue = specularColor;
                    }
                    else if (IsEnabledE == false)
                    {
                        ColorValue = emissionColor;
                    }

                }
            }   

        }

        /// <summary>
        /// 点击 AmbCommand 方法
        /// </summary>

        public VCommand AmbCommand { get; set; }

        private void AmbCmd()
        {
            IsEnabledA = false;
            IsEnabledD = true;
            IsEnabledS = true;
            IsEnabledE = true;

            SendColorValue();

        }

        /// <summary>
        /// 发送ColorValue值
        /// </summary>
        private void SendColorValue()
        {
             //  指的是Color.R的颜色,G的是Color.G的颜色,B的是Color.B的颜色，A的是指的Color.A的就是指的透明图
            string amb = string.Format("{0},{1},{2},{3}", Convert.ToDouble((double)ambientColor.R/255).ToString(), Convert.ToDouble((double)ambientColor.G/255).ToString(), 
                Convert.ToDouble((double)ambientColor.B/255).ToString(), Convert.ToDouble((double) ambientColor.A/255).ToString());

            //  指的是Color.R的颜色,G的是Color.G的颜色,B的是Color.B的颜色，A的是指的Color.A的就是指的透明图
            string dff = string.Format("{0},{1},{2},{3}", Convert.ToDouble((double) diffuseColor.R/255).ToString(), Convert.ToDouble( (double)diffuseColor.G/255).ToString(),
               Convert.ToDouble((double) diffuseColor.B/255).ToString(), Convert.ToDouble((double)diffuseColor.A/255).ToString());
            //  指的是Color.R的颜色,G的是Color.G的颜色,B的是Color.B的颜色，A的是指的Color.A的就是指的透明图
            string spec = string.Format("{0},{1},{2},{3}", Convert.ToDouble((double)specularColor.R/255).ToString(), Convert.ToDouble((double) specularColor.G/255).ToString(), 
               Convert.ToDouble((double) specularColor.B/255).ToString(), Convert.ToDouble((double) specularColor.A/255).ToString());
            //  指的是Color.R的颜色,G的是Color.G的颜色,B的是Color.B的颜色，A的是指的Color.A的就是指的透明图
            string emission = string.Format("{0},{1},{2},{3}", Convert.ToDouble((double) emissionColor.R/255).ToString(), Convert.ToDouble((double) emissionColor.G/255).ToString(),
               Convert.ToDouble((double) emissionColor.B/255).ToString(), Convert.ToDouble((double) emissionColor.A/255).ToString());

            //组装字符串说明 Enable;Shiness;Alpha;Ambient;Diffuse;specular;emission 
            fieldValue = string.Format("1;{0};{1};{2};{3};{4};{5}", Shininess, Alpha, amb, dff, spec, emission);

            this.ControlField.Value = fieldValue;

            // 没有预览连接
            //if (ApplicationDomainEx.PreviewConn == null)
            //    return;

            //// 没有控制对象或控制字段
            //if (this.ControlObject == null || this.ControlField == null)
            //    return;

            //this.VizCommandControlObjectService.SetControlObjectValue(
            //    ApplicationDomainEx.PreviewConn,
            //    ApplicationDomainEx.CurrentPage.GetVizScene(),
            //    this.ControlObject.TreeNodePath,
            //    this.ControlField.FieldIdentifier,
            //    this.ControlField.Value);

        }

        /// <summary>
        /// 禁用全部发送Color的值
        /// </summary>
        private void SendIsEnbaleAll()
        {
            //byte[] bytes = { eColor.R};

            // double scr = BitConverter.ToDouble(bytes,1);

            //Ambient   返回数组R,G,B,A
            string ecolor = string.Format("{0},{1},{2},{3}", Convert.ToDouble((double)eColor.R/255).ToString(), Convert.ToDouble((double)eColor.G/255).ToString(), 
                Convert.ToDouble((double)eColor.B/255).ToString(),Convert.ToDouble((double)eColor.A/255).ToString());

            //组装字符串说明 Enable;Shiness;Alpha;Color颜色 
            fieldValue = string.Format("0;{0};{1};{2}", Shininess, Alpha, ecolor);

            this.ControlField.Value = fieldValue;

            //// 没有预览连接
            //if (ApplicationDomainEx.PreviewConn == null)
            //    return;

            //// 没有控制对象或控制字段
            //if (this.ControlObject == null || this.ControlField == null)
            //    return;

            //this.VizCommandControlObjectService.SetControlObjectValue(
            //    ApplicationDomainEx.PreviewConn,
            //    ApplicationDomainEx.CurrentPage.GetVizScene(),
            //    this.ControlObject.TreeNodePath,
            //    this.ControlField.FieldIdentifier,
            //    this.ControlField.Value);
        }


        /// <summary>
        /// 点击 DiffCommand
        /// </summary>
        public VCommand DiffCommand { get; set; }

        private void DiffCmd()
        {
            IsEnabledA = true;
            IsEnabledD = false;
            IsEnabledS = true;
            IsEnabledE = true;

            SendColorValue();
        }

        /// <summary>
        /// 点击 SpecCommand 方法
        /// </summary>
        public VCommand SpecCommand { get; set; }


        private void SpecCmd()
        {
            IsEnabledA = true;
            IsEnabledD = true;
            IsEnabledS = false;
            IsEnabledE = true;

            SendColorValue();


        }
        /// <summary>
        /// 点击 EmisCommand 方法
        /// </summary>
        public VCommand EmisCommand { get; set; }

        private void EmisCmd()
        {
            IsEnabledA = true;
            IsEnabledD = true;
            IsEnabledS = true;
            IsEnabledE = false;

            SendColorValue();

        }

    }
}
