﻿using DevExpress.Xpf.Docking;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    /// <summary>
    /// MainView.xaml 的交互逻辑
    /// </summary>
    public partial class MainView : UserControl
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(MainView));

        public MainView()
        {
            InitializeComponent();

            this.CheckDll();

            WPFHelper.BindingViewModel(this, new MainViewModel());
        }

        /// <summary>
        /// 监测DLL
        /// </summary>
        private void CheckDll()
        {
            // 入口
            ApplicationDllCheckAttribute entry_attribute = Assembly.GetEntryAssembly().GetCustomAttribute<ApplicationDllCheckAttribute>();
            if (entry_attribute == null || string.IsNullOrWhiteSpace(entry_attribute.Key))
            {
                log.Error("dll check error.");
                throw new Exception("dll check error.");
            }

            // 模块
            ApplicationDllCheckAttribute module_attribute = this.GetType().Assembly.GetCustomAttribute<ApplicationDllCheckAttribute>();
            if (module_attribute == null || string.IsNullOrWhiteSpace(module_attribute.Key))
            {
                log.Error("dll check error.");
                throw new Exception("dll check error.");
            }

            // 不匹配
            if (!string.Equals(entry_attribute.Key, module_attribute.Key))
            {
                log.Error("dll check error.");
                throw new Exception("dll check error.");
            }
        }
    }
}
