﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 页分组服务
    /// </summary>
    public interface IPageGroupService : IService
    {
        /// <summary>
        /// 创建并添加命令模板页
        /// </summary>
        /// <returns>页</returns>
        PageModel AddCmdPage();

        /// <summary>
        /// 添加页
        /// </summary>
        /// <param name="template">模板</param>
        /// <returns>页</returns>
        PageModel AddPage(PageTemplateModel template);

        /// <summary>
        /// 拷贝页
        /// </summary>
        /// <returns>页</returns>
        PageModel CopyPage();

        /// <summary>
        /// 打开页
        /// </summary>
        /// <param name="page">页</param>
        void OpenPage(PageModel page);

        /// <summary>
        /// 尝试改变页号
        /// </summary>
        /// <param name="page">页</param>
        /// <param name="pageNum">页号</param>
        /// <returns>是否成功改变</returns>
        bool TryChangePageNum(PageModel page, int pageNum);
    }
}
