﻿using DevExpress.Xpf.Core;
using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;

namespace VIZ.Package.Module
{
    /// <summary>
    /// PageGroupView.xaml 的交互逻辑
    /// </summary>
    public partial class PageGroupView : UserControl
    {
        public PageGroupView()
        {
            InitializeComponent();

            WPFHelper.BindingViewModel(this, new PageGroupViewModel());
        }

        /// <summary>
        /// 当前可见的表视图
        /// </summary>
        public TableView CurrentIsVisibleTableView;

        /// <summary>
        /// 表视图可见性改变时触发
        /// </summary>
        private void TableView_IsVisibleChanged(object sender, DependencyPropertyChangedEventArgs e)
        {
            if ((bool)e.NewValue == true)
            {
                this.CurrentIsVisibleTableView = sender as TableView;
            }
        }
    }
}
