﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Plugin;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 页添加视图模型
    /// </summary>
    public class PageAddViewModel : ViewModelBase
    {
        public PageAddViewModel()
        {
            // 初始化命令
            this.initCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void initCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
            this.EnterCommand = new VCommand(this.Enter);
            this.CancelCommand = new VCommand(this.Cancel);
        }

        // ===========================================================
        // Property
        // ===========================================================

        #region Scene -- 场景

        private string scene;
        /// <summary>
        /// 场景
        /// </summary>
        public string Scene
        {
            get { return scene; }
            set { scene = value; this.RaisePropertyChanged(nameof(Scene)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region Layer -- 层

        private VizLayer layer;
        /// <summary>
        /// 层
        /// </summary>
        public VizLayer Layer
        {
            get { return layer; }
            set { layer = value; this.RaisePropertyChanged(nameof(Layer)); }
        }

        #endregion

        #region TemplatePlugins -- 模板插件集合

        private List<PluginInfo> templatePlugins;
        /// <summary>
        /// 模板插件集合
        /// </summary>
        public List<PluginInfo> TemplatePlugins
        {
            get { return templatePlugins; }
            set { templatePlugins = value; this.RaisePropertyChanged(nameof(TemplatePlugins)); }
        }

        #endregion

        #region SelectedTemplatePlugin -- 选中的模板插件

        private PluginInfo selectedTemplatePlugin;
        /// <summary>
        /// 选中的模板插件
        /// </summary>
        public PluginInfo SelectedTemplatePlugin
        {
            get { return selectedTemplatePlugin; }
            set { selectedTemplatePlugin = value; this.RaisePropertyChanged(nameof(SelectedTemplatePlugin)); }
        }

        #endregion

        // -------------------------------------------------------------------
        // 切换逻辑

        #region TransitionLogic -- 是否为切换逻辑层

        private bool transitionLogic;
        /// <summary>
        /// 是否为切换逻辑层
        /// </summary>
        public bool TransitionLogic
        {
            get { return transitionLogic; }
            set { transitionLogic = value; this.RaisePropertyChanged(nameof(TransitionLogic)); }
        }

        #endregion

        #region LayerIdentifier -- 切换逻辑层名

        private string layerIdentifier;
        /// <summary>
        /// 切换逻辑层名
        /// </summary>
        public string LayerIdentifier
        {
            get { return layerIdentifier; }
            set { layerIdentifier = value; this.RaisePropertyChanged(nameof(LayerIdentifier)); }
        }

        #endregion

        #region StateIdentifier -- 进入方式

        private string stateIdentifier;
        /// <summary>
        /// 进入方式
        /// </summary>
        public string StateIdentifier
        {
            get { return stateIdentifier; }
            set { stateIdentifier = value; this.RaisePropertyChanged(nameof(StateIdentifier)); }
        }

        #endregion

        #region BackgroundScene -- 背景层

        private string backgroundScene;
        /// <summary>
        /// 背景层
        /// </summary>
        public string BackgroundScene
        {
            get { return backgroundScene; }
            set { backgroundScene = value; }
        }

        #endregion

        // ===========================================================
        // Command
        // ===========================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            // 模板插件集合
            var list = ApplicationDomainEx.PluginInfos.Where(
                           p => !string.IsNullOrWhiteSpace(p.Group) &&
                                p.Group != ApplicationConstants.APPLICATION_GROUP_NAME &&
                                p.Group == ApplicationDomainEx.VizConfig.PluginGroup &&
                                p.PluginType == PluginType.Page).ToList();

            list.Insert(0, PluginInfo.NONE);
            this.TemplatePlugins = list;
            // 选择默认模板
            PluginMapping mapping = ApplicationDomainEx.PluginMappingConfig?.Mappings?.FirstOrDefault(p => p.Scene == this.Scene);
            if (mapping != null)
            {
                this.SelectedTemplatePlugin = this.TemplatePlugins.FirstOrDefault(p => p != PluginInfo.NONE && p.ID == mapping.PluginID);
            }
        }

        #endregion

        #region EnterCommand -- 确定命令

        /// <summary>
        /// 确定命令
        /// </summary>
        public VCommand EnterCommand { get; set; }

        /// <summary>
        /// 确定
        /// </summary>
        private void Enter()
        {
            Window window = this.GetWindow();
            if (window == null)
                return;

            window.DialogResult = true;

            window.Close();
        }

        #endregion

        #region CancelCommand -- 取消命令

        /// <summary>
        /// 取消命令
        /// </summary>
        public VCommand CancelCommand { get; set; }

        /// <summary>
        /// 取消
        /// </summary>
        private void Cancel()
        {
            Window window = this.GetWindow();
            if (window == null)
                return;

            window.DialogResult = false;

            window.Close();
        }

        #endregion
    }
}