﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// GHResourcePanel.xaml 的交互逻辑
    /// </summary>
    public partial class GHResourcePanel : UserControl
    {
        public GHResourcePanel()
        {
            InitializeComponent();
        }

        #region FolderContextMenu -- 文件夹右键菜单

        /// <summary>
        /// 文件夹右键菜单
        /// </summary>
        public ContextMenu FolderContextMenu
        {
            get { return (ContextMenu)GetValue(FolderContextMenuProperty); }
            set { SetValue(FolderContextMenuProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for FolderContextMenu.  This enables animation, styling, binding, etc... 
        /// </summary>
        public static readonly DependencyProperty FolderContextMenuProperty =
            DependencyProperty.Register("FolderContextMenu", typeof(ContextMenu), typeof(GHResourcePanel), new PropertyMetadata(null));

        #endregion

        #region FileContextMenu -- 文件右键菜单

        /// <summary>
        /// 文件右键菜单
        /// </summary>
        public ContextMenu FileContextMenu
        {
            get { return (ContextMenu)GetValue(FileContextMenuProperty); }
            set { SetValue(FileContextMenuProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for FileContextMenu.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty FileContextMenuProperty =
            DependencyProperty.Register("FileContextMenu", typeof(ContextMenu), typeof(GHResourcePanel), new PropertyMetadata(null));

        #endregion

        #region FileSelectionMode -- 文件选择模式

        /// <summary>
        /// 文件选择模式
        /// </summary>
        public ResourceFileSelectionMode FileSelectionMode
        {
            get { return (ResourceFileSelectionMode)GetValue(FileSelectionModeProperty); }
            set { SetValue(FileSelectionModeProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for FileSelectionMode.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty FileSelectionModeProperty =
            DependencyProperty.Register("FileSelectionMode", typeof(ResourceFileSelectionMode), typeof(GHResourcePanel), new PropertyMetadata(ResourceFileSelectionMode.Single));

        #endregion
    }
}
