﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 媒资库配置设置视图模型
    /// </summary>
    public class MediaSettingViewModel : ViewModelBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(MediaSettingViewModel));

        /// <summary>
        /// 媒资库配置设置视图模型
        /// </summary>
        public MediaSettingViewModel()
        {
            // 初始化命令
            this.InitCommand();
        }

        /// <summary>
        /// 初始化命令
        /// </summary>
        private void InitCommand()
        {
            this.LoadedCommand = new VCommand(this.Loaded);
        }

        // =========================================================================
        // Property
        // =========================================================================

        #region Url -- 地址

        private string url;
        /// <summary>
        /// 地址
        /// </summary>
        public string Url
        {
            get { return url; }
            set { url = value; this.RaisePropertyChanged(nameof(Url)); }
        }

        #endregion

        #region MediaFilter -- 媒资筛选

        private string mediaFilter;
        /// <summary>
        /// 媒资筛选
        /// </summary>
        public string MediaFilter
        {
            get { return mediaFilter; }
            set { mediaFilter = value; this.RaisePropertyChanged(nameof(MediaFilter)); }
        }

        #endregion

        // =========================================================================
        // Command
        // =========================================================================

        #region LoadedCommand -- 加载命令

        /// <summary>
        /// 加载命令
        /// </summary>
        public VCommand LoadedCommand { get; set; }

        /// <summary>
        /// 加载
        /// </summary>
        private void Loaded()
        {
            MediaConfigEntity config = ApplicationDomainEx.MediaConfig;

            this.Url = config.Url;
            this.MediaFilter = config.MediaFilter;
        }

        #endregion

        // =========================================================================
        // Public Function
        // =========================================================================

        /// <summary>
        /// 保存
        /// </summary>
        public void Save()
        {
            MediaConfigEntity config = ApplicationDomainEx.MediaConfig;

            config.Url = this.Url;
            config.MediaFilter = this.MediaFilter;

            ApplicationDomainEx.LocalDbContext.MediaConfig.Upsert(config);
        }
    }
}