﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using VIZ.Framework.Core;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 控制对象元素节点
    /// </summary>
    public class ControlObject_Element_Node : IXmlSerialize
    {
        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 是否完成
        /// </summary>
        public bool? Complete { get; set; }

        /// <summary>
        /// 关联场景
        /// </summary>
        public string Scene { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// 实体集合
        /// </summary>
        public List<ControlObject_Entry_Node> Entrys { get; set; } = new List<ControlObject_Entry_Node>();

        /// <summary>
        /// 字段定义
        /// </summary>
        public List<ControlObject_Schema_Node> Schemas { get; set; } = new List<ControlObject_Schema_Node>();

        /// <summary>
        /// 从XElement节点获取数据
        /// </summary>
        /// <param name="element">XElement节点</param>
        public void FromXmlElement(XElement element)
        {
            this.Name = element.GetAttributeValue<string>("name");
            this.Description = element.GetAttributeValue<string>("description");
            this.Complete = element.GetAttributeValue<bool?>("complete");
            this.Scene = element.GetAttributeValue<string>("scene");

            foreach (var item in element.Elements("entry"))
            {
                ControlObject_Entry_Node entry = new ControlObject_Entry_Node();
                entry.FromXmlElement(item);

                this.Entrys.Add(entry);
            }

            foreach (var item in element.Elements("schema"))
            {
                ControlObject_Schema_Node schema = new ControlObject_Schema_Node();
                schema.FromXmlElement(item);

                this.Schemas.Add(schema);
            }
        }

        /// <summary>
        /// 转化为XElement节点
        /// </summary>
        public XElement ToXmlElement()
        {
            XElement element = new XElement("element");
            element.SetAttributeValueIfValueNotNull("name", this.Name);
            element.SetAttributeValueIfValueNotNull("description", this.Description);
            element.SetAttributeValueIfValueNotNull("complete", this.Complete);
            element.SetAttributeValueIfValueNotNull("scene", this.Scene);

            foreach (var item in this.Entrys)
            {
                XElement entry = item.ToXmlElement();
                if (entry == null)
                    continue;

                element.Add(entry);
            }

            foreach (var item in this.Schemas)
            {
                XElement schema = item.ToXmlElement();
                if (schema == null)
                    continue;

                element.Add(schema);
            }

            return element;
        }
    }
}
