﻿using DevExpress.Xpf.Core;
using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using VIZ.Framework.Module;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : ThemedWindow
    {
        /// <summary>
        /// 日志
        /// </summary>
        private readonly static ILog log = LogManager.GetLogger(typeof(MainWindow));

        /// <summary>
        /// 操作日志服务
        /// </summary>
        private RecordLogService recordLogService = new RecordLogService();

        public MainWindow()
        {
            InitializeComponent();

            this.Closing += MainWindow_Closing;
            this.Closed += MainWindow_Closed;
        }

        /// <summary>
        /// 关闭窗口前触发
        /// </summary>
        private void MainWindow_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            // 发送系统关闭消息
            try
            {
                ApplicationClosingMessage closeingMsg = new ApplicationClosingMessage();
                ApplicationDomainEx.MessageManager.Send(closeingMsg);

                // 如果取消关闭
                if (closeingMsg.Cancel)
                {
                    e.Cancel = true;

                    return;
                }

                // 发送确定关闭消息
                ApplicationClosedMessage closedMsg = new ApplicationClosedMessage();
                ApplicationDomainEx.MessageManager.Send(closedMsg);
            }
            catch (Exception ex)
            {
                log.Error(ex);
            }
        }

        /// <summary>
        /// 关闭窗口
        /// </summary>
        private void MainWindow_Closed(object sender, EventArgs e)
        {
            // 记录操作日志
            this.recordLogService.AppendLog(ApplicationConstants.APPLICATION_GROUP_NAME, Storage.RecordLogOperate.Operate, Storage.RecordLogTrigger.Human, RecordLogConstants.OPERATE_SHUTDOWN);

            // 启动结束流程
            AppSetup.ShutDown();

            // 结束进程
            Environment.Exit(0);
        }
    }
}
