﻿using DevExpress.Xpf.Grid;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using VIZ.Framework.Common;

namespace VIZ.Package.Common
{
    /// <summary>
    /// 列表列重置行行高
    /// </summary>
    public class GridColumnResizeMinHeight : GridColumn
    {
        #region AspectRatio -- 宽高比

        /// <summary>
        /// 宽高比
        /// </summary>
        public double AspectRatio
        {
            get { return (double)GetValue(AspectRatioProperty); }
            set { SetValue(AspectRatioProperty, value); }
        }

        /// <summary>
        /// Using a DependencyProperty as the backing store for AspectRatio.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty AspectRatioProperty =
            DependencyProperty.Register("AspectRatio", typeof(double), typeof(GridColumnResizeMinHeight), new PropertyMetadata(16d / 9d));

        #endregion

        #region Offset -- 偏移量

        /// <summary>
        /// 偏移量
        /// </summary>
        public double Offset
        {
            get { return (double)GetValue(OffsetProperty); }
            set { SetValue(OffsetProperty, value); }
        }

        /// <summary>
        ///  Using a DependencyProperty as the backing store for Offset.  This enables animation, styling, binding, etc...
        /// </summary>
        public static readonly DependencyProperty OffsetProperty =
            DependencyProperty.Register("Offset", typeof(double), typeof(GridColumnResizeMinHeight), new PropertyMetadata(2d));

        #endregion

        protected override void OnWidthChanged(GridColumnWidth oldValue)
        {
            base.OnWidthChanged(oldValue);

            this.ResizeMinHeight();
        }

        /// <summary>
        /// 重置最小高度
        /// </summary>
        private void ResizeMinHeight()
        {
            if (this.View is TableView view)
            {
                double height = (this.Width.Value / this.AspectRatio) + this.Offset;

                if (view.RowMinHeight != height)
                {
                    view.RowMinHeight = height;
                }
            }
        }
    }
}
