﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using System.Windows;
using VIZ.Framework.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 应用程序域
    /// </summary>
    public partial class ApplicationDomainEx : ApplicationDomain
    {
        // =============================================================
        // 窗口
        // =============================================================

        /// <summary>
        /// 登录窗口
        /// </summary>
        public static Window LoginWindow { get; set; }

        /// <summary>
        /// 主窗口
        /// </summary>
        public static Window MainWindow { get; set; }

        /// <summary>
        /// 主窗口类型
        /// </summary>
        public static Type MainWindowType { get; set; }

        /// <summary>
        /// 字段编辑窗口
        /// </summary>
        public static Window FieldEditWindow { get; set; }

        /// <summary>
        /// Viz命令日志窗口
        /// </summary>
        public static Window VizCommandLogWindow { get; set; }

        /// <summary>
        /// 错误日志窗口
        /// </summary>
        public static Window ErrorLogWindow { get; set; }

        // =============================================================
        // 数据
        // =============================================================

        /// <summary>
        /// 本地数据
        /// </summary>
        public static LocalDbContext LocalDbContext { get; set; }

        /// <summary>
        /// 项目数据
        /// </summary>
        public static ProjectDbContext ProjectDbContext { get; set; }

        /// <summary>
        /// CSV数据上下文
        /// </summary>
        public static CsvDbContext CsvDbContext { get; set; }

        // =============================================================
        // 配置
        // =============================================================

        /// <summary>
        /// Viz预览是否可用
        /// </summary>
        public static bool IsVizPreviewReadly { get; set; }

        /// <summary>
        /// Viz配置
        /// </summary>
        public static VizConfigEntity VizConfig { get; set; }

        /// <summary>
        /// 媒资库配置
        /// </summary>
        public static MediaConfigEntity MediaConfig { get; set; }

        /// <summary>
        /// 热键配置
        /// </summary>
        public static HotKeyConfigEntity HotKeyConfig { get; set; }

        /// <summary>
        /// 插件信息
        /// </summary>
        public static List<PluginInfo> PluginInfos { get; set; }

        /// <summary>
        /// 插件映射配置
        /// </summary>
        public static PluginMappingConfigEntity PluginMappingConfig { get; set; }

        // =============================================================
        // 其他
        // =============================================================

        /// <summary>
        /// 预览连接分组
        /// </summary>
        public static ConnGroupModel PreviewConnGroup { get; set; }

        /// <summary>
        /// 预览连接
        /// </summary>
        public static ConnModel PreviewConn { get; set; }

        /// <summary>
        /// 连接分组
        /// </summary>
        public static ObservableCollection<ConnGroupModel> ConnGroups { get; private set; } = new ObservableCollection<ConnGroupModel>();

        /// <summary>
        /// Viz预览进程
        /// </summary>
        public static Process VizPreviewProcess { get; set; }

        /// <summary>
        /// Viz预览渲染器名称
        /// </summary>
        public static string VizPreviewRenderer { get; set; }

        /// <summary>
        /// 当前页或模板
        /// </summary>
        public static PageModelBase CurrentPage { get; set; }

        /// <summary>
        /// 当前上板的页或模板
        /// </summary>
        public static PageModelBase CurrentTake { get; set; }

        /// <summary>
        /// 场景是否正在加载
        /// </summary>
        public static bool IsSceneLoading { get; set; }

        /// <summary>
        /// 是否正在设置热键
        /// </summary>
        public static bool IsHotkeySetting { get; set; }

        /// <summary>
        /// 场景信息列表
        /// </summary>
        /// <remarks>
        /// 该值不会入库，仅在内存中保留
        /// </remarks>
        public static List<SceneInfoModel> SceneInfoList { get; private set; } = new List<SceneInfoModel>();

        /// <summary>
        /// 切换逻辑背景场景信息
        /// </summary>
        /// <remarks>
        /// 该值不会入库，仅在内存中保留
        /// </remarks>
        public static List<TransitionLogicSceneInfoModel> SceneInfoListWithTransitionLogic { get; private set; } = new List<TransitionLogicSceneInfoModel>();

        /// <summary>
        /// 时钟控件保存信息
        /// </summary>
        public static ClockFieldEntity ClockField { get; set; }
    }
}
