﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 控制对象模型
    /// </summary>
    public class ControlObjectModel : ModelBase
    {
        #region TreeNodeName -- 所在场景节点名称

        private string treeNodeName;
        /// <summary>
        /// 所在场景节点名称
        /// </summary>
        public string TreeNodeName
        {
            get { return treeNodeName; }
            set { treeNodeName = value; this.RaisePropertyChanged(nameof(TreeNodeName)); }
        }

        #endregion

        #region TreeNodePath -- 所在场景节点路径

        private string treeNodePath;
        /// <summary>
        /// 所在场景节点路径
        /// </summary>
        public string TreeNodePath
        {
            get { return treeNodePath; }
            set { treeNodePath = value; this.RaisePropertyChanged(nameof(TreeNodePath)); }
        }

        #endregion

        #region Description -- 描述

        private string description;
        /// <summary>
        /// 描述
        /// </summary>
        public string Description
        {
            get { return description; }
            set { description = value; this.RaisePropertyChanged(nameof(Description)); }
        }

        #endregion

        #region FieldDetails -- 字段描述

        private string fieldDetails;
        /// <summary>
        /// 字段描述
        /// </summary>
        public string FieldDetails
        {
            get { return fieldDetails; }
            set { fieldDetails = value; this.RaisePropertyChanged(nameof(FieldDetails)); }
        }

        #endregion

        #region CustomFieldDetails -- 自定义字段描述

        private string customFieldDetails;
        /// <summary>
        /// 自定义字段描述
        /// </summary>
        public string CustomFieldDetails
        {
            get { return customFieldDetails; }
            set { customFieldDetails = value; this.RaisePropertyChanged(nameof(CustomFieldDetails)); }
        }

        #endregion

        #region FieldNodes -- 字段节点集合

        private List<ControlFieldNodeModel> fieldNodes = new List<ControlFieldNodeModel>();
        /// <summary>
        /// 字段节点集合
        /// </summary>
        public List<ControlFieldNodeModel> FieldNodes
        {
            get { return fieldNodes; }
            set { fieldNodes = value; this.RaisePropertyChanged(nameof(FieldNodes)); }
        }

        #endregion

        #region AllFiledNodes -- 所有字段节点集合

        private List<ControlFieldNodeModel> allFiledNodes = new List<ControlFieldNodeModel>();
        /// <summary>
        /// 所有字段节点集合
        /// </summary>
        public List<ControlFieldNodeModel> AllFiledNodes
        {
            get { return allFiledNodes; }
            set { allFiledNodes = value; this.RaisePropertyChanged(nameof(AllFiledNodes)); }
        }

        #endregion

        #region UseAllDirectors -- 使用所有的控制器

        private bool useAllDirectors;
        /// <summary>
        /// 使用所有的控制器
        /// </summary>
        public bool UseAllDirectors
        {
            get { return useAllDirectors; }
            set { useAllDirectors = value; this.RaisePropertyChanged(nameof(UseAllDirectors)); }
        }

        #endregion

        // -------------------------------------------------------------------
        // 切换逻辑

        #region TransitionLogic -- 是否为切换逻辑层

        private bool transitionLogic;
        /// <summary>
        /// 是否为切换逻辑层
        /// </summary>
        public bool TransitionLogic
        {
            get { return transitionLogic; }
            set { transitionLogic = value; this.RaisePropertyChanged(nameof(TransitionLogic)); }
        }

        #endregion

        #region LayerIdentifier -- 切换逻辑层名

        private string layerIdentifier;
        /// <summary>
        /// 切换逻辑层名
        /// </summary>
        public string LayerIdentifier
        {
            get { return layerIdentifier; }
            set { layerIdentifier = value; this.RaisePropertyChanged(nameof(LayerIdentifier)); }
        }

        #endregion

        #region StateIdentifier -- 进入方式

        private string stateIdentifier;
        /// <summary>
        /// 进入方式
        /// </summary>
        public string StateIdentifier
        {
            get { return stateIdentifier; }
            set { stateIdentifier = value; this.RaisePropertyChanged(nameof(StateIdentifier)); }
        }

        #endregion

        #region BackgroundScene -- 背景层

        private string backgroundScene;
        /// <summary>
        /// 背景层
        /// </summary>
        public string BackgroundScene
        {
            get { return backgroundScene; }
            set { backgroundScene = value; }
        }

        #endregion
    }
}
