﻿using DevExpress.Xpf.Editors;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 富文本底飞单元格编辑
    /// </summary>
    public class RichTextScrollElementCellEdit : RichTextListCellEdit
    {
        /// <summary>
        /// 值改变时触发
        /// </summary>
        protected override void EditValueChanged(object sender, EditValueChangedEventArgs e)
        {
            // 是否需要发送至预览
            if (!this.IsSendToPreview)
                return;

            // 预览连接不存在
            if (ApplicationDomainEx.PreviewConn == null)
                return;

            DevExpress.Xpf.Grid.EditGridCellData cellData = this.DataContext as DevExpress.Xpf.Grid.EditGridCellData;
            if (cellData == null)
                return;

            GridColumnControlFieldDefinition columnDefinition = cellData.Column.DataContext as GridColumnControlFieldDefinition;
            if (columnDefinition == null)
                return;

            string richText = $"{RICH_TEXT_LEFT}{e.NewValue?.ToString() ?? string.Empty}{RICH_TEXT_RIGHT}";

            // 设置值
            IDictionary<string, object> dic = cellData.Row as IDictionary<string, object>;
            dic[columnDefinition.FieldName] = richText;

            // 向Viz发送指令
            //this.VizCommandControlObjectService.SetControlObjectListValue(
            //    ApplicationDomainEx.PreviewConn,
            //    columnDefinition.ControlObject.TreeNodePath,
            //    columnDefinition.ControlField.FieldIdentifier,
            //    cellData.RowData.RowHandle.Value,
            //    columnDefinition.FieldName,
            //    richText);
        }
    }
}
