﻿using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Service;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 文本编辑面板模型
    /// </summary>
    public class TextEditPanelModel : EditPanelModelBase
    {
        // ============================================================
        // Property
        // ============================================================

        #region Text -- 文本

        private string text;
        /// <summary>
        /// 文本
        /// </summary>
        public string Text
        {
            get { return text; }
            set
            {
                text = value;
                this.RaisePropertyChanged(nameof(Text));
                this.OnTextChanged();
            }
        }

        #endregion

        // ============================================================
        // Message
        // ============================================================

        // ============================================================
        // Public Function
        // ============================================================

        /// <summary>
        /// 更新
        /// </summary>
        /// <param name="controlObject">控制对象</param>
        /// <param name="controlField">控制字段</param>
        public override void Update(ControlObjectModel controlObject, ControlFieldNodeModel controlField)
        {
            base.Update(controlObject, controlField);

            this.IsSendToPreview = false;
            this.Text = controlField?.Value;
            this.IsSendToPreview = true;
        }

        /// <summary>
        /// 更新动态数据
        /// </summary>
        /// <param name="listCellEdit">列单元格编辑器</param>
        /// <param name="columnDefinition">列定义</param>
        /// <param name="rowHandle">行号</param>
        /// <param name="row">行数据</param>
        public override void UpdateDynamic(ListCellEditBase listCellEdit, GridColumnControlFieldDefinition columnDefinition, int rowHandle, ExpandoObject row)
        {
            base.UpdateDynamic(listCellEdit, columnDefinition, rowHandle, row);

            IDictionary<string, object> dic = row as IDictionary<string, object>;

            this.IsSendToPreview = false;
            this.Text = dic?[columnDefinition.FieldName]?.ToString();
            this.IsSendToPreview = true;
        }

        /// <summary>
        /// 获取字段值
        /// </summary>
        /// <returns>字段值</returns>
        public override string GetFieldValue()
        {
            return this.Text;
        }

        // ============================================================
        // Private Function
        // ============================================================

        /// <summary>
        /// 文本值改变时触发
        /// </summary>
        private void OnTextChanged()
        {
            // 不需要向预览发送值
            if (!this.IsSendToPreview)
                return;

            // 没有预览连接
            if (ApplicationDomainEx.PreviewConn == null)
                return;

            // 没有控制对象或控制字段
            if (this.ControlObject == null || this.ControlField == null)
                return;

            // 正常模式编辑
            if (this.FieldEditMode == FieldEditMode.Normal)
            {
                this.ControlField.Value = this.Text;

                if (!this.ControlField.IsCustom)
                {
                    this.VizCommandControlObjectService.SetControlObjectValue(
                                    ApplicationDomainEx.PreviewConn,
                                    ApplicationDomainEx.CurrentPage.GetVizScene(),
                                    this.ControlObject.TreeNodePath,
                                    this.ControlField.FieldIdentifier,
                                    this.ControlField.Value);
                }
                else
                {
                    this.VizCommandControlObjectService.SetCustomControlFieldValue(ApplicationDomainEx.PreviewConn, new List<ControlFieldNodeModel> { this.ControlField });
                }

                return;
            }

            // 没有列信息或行数据
            if (this.ColumnDefinition == null || this.Row == null)
                return;

            // 动态模式编辑
            if (this.FieldEditMode == FieldEditMode.Dynamic)
            {
                IDictionary<string, object> dic = this.Row as IDictionary<string, object>;
                dic[this.ColumnDefinition.FieldName] = this.Text;

                this.ListCellEdit.UpdateEditValue(this.ColumnDefinition, this.RowHandle, this.Row);

                return;
            }
        }
    }
}
