﻿using DevExpress.Xpf.Core;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Interop;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Module
{
    /// <summary>
    /// Interaction logic for FieldEditWindow.xaml
    /// </summary>
    public partial class FieldEditWindow : ThemedWindow
    {
        public FieldEditWindow()
        {
            InitializeComponent();

            this.Closing += FieldEditWindow_Closing;

            WPFHelper.BindingViewModel(this, new FieldEditWindowModel());
        }

        /// <summary>
        /// 窗口句柄辅助类
        /// </summary>
        private WindowInteropHelper windowInteropHelper;

        /// <summary>
        /// 窗口关闭之前触发
        /// </summary>
        private void FieldEditWindow_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            e.Cancel = true;

            this.ShowInTaskbar = false;
            this.Visibility = Visibility.Collapsed;

            if (this.Owner == null)
                return;

            if (this.windowInteropHelper == null)
            {
                this.windowInteropHelper = new WindowInteropHelper(this.Owner);
            }

            Win32Helper.SetWindowPos(this.windowInteropHelper.Handle, new IntPtr(Win32Helper.HWND_NOTOPMOST), 0, 0, 0, 0, Win32Helper.SWP_NOMOVE | Win32Helper.SWP_NOSIZE);
        }
    }
}
