﻿using log4net;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Module;
using VIZ.Package.Domain;
using VIZ.Package.Service;
using VIZ.Package.Storage;

namespace VIZ.Package.Module
{
    /// <summary>
    /// 应用程序启动 -- 初始化操作日志
    /// </summary>
    public class AppSetup_InitRecordLog : AppSetupBase
    {
        /// <summary>
        /// 日志
        /// </summary>
        private static ILog log = LogManager.GetLogger(typeof(AppSetup_InitRecordLog));

        /// <summary>
        /// 描述
        /// </summary>
        public override string Detail { get; } = "应用程序启动 -- 初始化操作日志";

        /// <summary>
        /// 执行启动
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        /// <returns>是否成功执行</returns>
        public override bool Setup(AppSetupContext context)
        {
            string workFolder = System.IO.Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "record_log");
            if (!System.IO.Directory.Exists(workFolder))
            {
                System.IO.Directory.CreateDirectory(workFolder);
            }
            RecordLogService.LogWriter = new RecordLogWriter(workFolder);
            RecordLogService.LogWriter.BeginWrite();

            return true;
        }

        /// <summary>
        /// 执行关闭
        /// </summary>
        /// <param name="context">应用程序启动上下文</param>
        public override void Shutdown(AppSetupContext context)
        {
            RecordLogService.LogWriter?.Dispose();
            RecordLogService.LogWriter = null;
        }
    }
}