﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;
using VIZ.Package.Storage;

namespace VIZ.Package.Service
{
    /// <summary>
    /// 操作日志服务
    /// </summary>
    public class RecordLogService
    {
        /// <summary>
        /// 日志写入器
        /// </summary>
        public static RecordLogWriter LogWriter { get; set; }

        /// <summary>
        /// 追加日志
        /// </summary>
        /// <param name="log">日志</param>
        public void AppendLog(string plugin, RecordLogOperate operate, RecordLogTrigger trigger, string detail)
        {
            this.AppendLog(plugin, operate, trigger, detail, string.Empty);
        }

        /// <summary>
        /// 追加日志
        /// </summary>
        /// <param name="log">日志</param>
        public void AppendLog(string plugin, RecordLogOperate operate, RecordLogTrigger trigger, string detail, string remark)
        {
            if (string.IsNullOrWhiteSpace(plugin))
                throw new ArgumentNullException(nameof(plugin));

            if (string.IsNullOrWhiteSpace(detail))
                throw new ArgumentNullException(nameof(detail));

            RecordLog record = new RecordLog();
            record.ID = ++RecordLog.ALL_ID;
            record.DateTime = DateTime.Now;
            record.Plugin = plugin;
            record.Operate = operate.GetDescription();
            record.Trigger = trigger.GetDescription();
            record.Detail = detail;
            record.Remark = remark;

            LogWriter?.AppendLog(record);
        }
    }
}
