﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;
using VIZ.Package.Domain;

namespace VIZ.Package.Service
{
    /// <summary>
    /// VIZ命令ControlObject服务 -- 自定义控制字段
    /// </summary>
    public partial class VizCommandControlObjectService
    {
        /// <summary>
        /// 获取控制字段信息
        /// </summary>
        /// <param name="conn">连接</param>
        /// <param name="obj">控制对象</param>
        /// <returns>控制字段列表</returns>
        public List<ControlFieldNodeModel> GetCustomControlFields(ConnModel conn, ControlObjectModel obj)
        {
            List<ControlFieldNodeModel> fields = new List<ControlFieldNodeModel>();

            // Step 1. 获取自定义字段
            string define = conn.EndpointManager.Request(string.Format(VizEngineCommands.SCRIPT_INVOKE, ApplicationConstants.VIZ_COMMAND_CUSTOM_CONTROL_FIELD_DEFINE, string.Empty));
            if (string.IsNullOrWhiteSpace(define) || ApplicationConstants.VIZ_COMMAND_RESULT_ERROR_PREFIX.StartsWith(define))
            {
                obj.CustomFieldDetails = null;
                return fields;
            }

            obj.CustomFieldDetails = define;

            // Step 2. 构建自定义字段信息
            fields = this.GetCustomControlFields(define, obj);

            return fields;
        }


        /// <summary>
        /// 设置自定义控制字段值
        /// </summary>
        /// <param name="conn">连接</param>
        /// <param name="fields">控制字段集合</param>
        public void SetCustomControlFieldValue(ConnModel conn, List<ControlFieldNodeModel> fields)
        {
            if (fields == null || fields.Count == 0)
                return;

            List<ControlFieldNodeModel> list = fields.Where(p => p.IsCustom).ToList();
            if (list.Count == 0)
                return;

            // FieldIdentifier|Value*FieldIdentifier|Value
            List<string> field_infos = list.Select(p => string.Format("{0}|{1}", p.FieldIdentifier, p.Value)).ToList();
            string command = string.Join("*", field_infos);

            conn.EndpointManager.Send(string.Format(VizEngineCommands.SCRIPT_INVOKE, ApplicationConstants.VIZ_COMMAND_CUSTOM_CONTROL_FIELD_SET, command));
        }

        /// <summary>
        /// 更新自定义控制字段
        /// </summary>
        /// <param name="conn">连接</param>
        /// <param name="model">控制对象</param>
        /// <param name="customFieldDetails">自定义控制字段描述</param>
        /// <param name="isGetValueFromViz">是否需要从Viz中获取数据</param>
        public void UpdateCustomControlOjbectField(ConnModel conn, ControlObjectModel model, string customFieldDetails, bool isGetValueFromViz)
        {
            List<ControlFieldNodeModel> fields = null;

            if (isGetValueFromViz)
            {
                fields = this.GetCustomControlFields(conn, model);
                model.FieldNodes.AddRange(fields);
                model.AllFiledNodes.AddRange(fields);

                return;
            }

            fields = this.GetCustomControlFields(model.CustomFieldDetails, model);
            model.FieldNodes.AddRange(fields);
            model.AllFiledNodes.AddRange(fields);
        }

        // ============================================================================================
        // Private Function
        // ============================================================================================

        /// <summary>
        /// 获取自定义字段
        /// </summary>
        /// <param name="customFieldDetails">自定义字段描述</param>
        /// <param name="obj">控制对象</param>
        /// <returns>自定义字段描述</returns>
        private List<ControlFieldNodeModel> GetCustomControlFields(string customFieldDetails, ControlObjectModel obj)
        {
            List<ControlFieldNodeModel> fields = new List<ControlFieldNodeModel>();
            if (string.IsNullOrWhiteSpace(customFieldDetails) || ApplicationConstants.VIZ_COMMAND_RESULT_ERROR_PREFIX.StartsWith(customFieldDetails))
                return fields;

            // FieldIdentifier|Value|Type|Description*FieldIdentifier|Value|Type|Description
            string[] define_fields = customFieldDetails.Split(new char[] { '*' }, StringSplitOptions.RemoveEmptyEntries);
            foreach (string define_field in define_fields)
            {
                if (string.IsNullOrWhiteSpace(define_field))
                    continue;

                // FieldIdentifier|Value|Type|Description
                string[] pars = define_field.Split(new char[] { '|' }, StringSplitOptions.RemoveEmptyEntries);
                if (pars.Length != 4)
                    continue;

                ControlFieldNodeModel model = new ControlFieldNodeModel();
                model.FieldIdentifier = pars[0];
                model.Value = pars[1];
                model.Type = this.GetControlFieldType(pars[2]);
                model.Description = pars[3];
                model.IsCustom = true;

                fields.Add(model);
            }

            return fields;
        }
    }
}
