﻿using LiteDB;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VIZ.Package.Storage
{
    /// <summary>
    /// 热键配置实体
    /// </summary>
    public class HotKeyConfigEntity
    {
        /// <summary>
        /// 编号
        /// </summary>
        [BsonId(true)]
        public int Id { get; set; }

        /// <summary>
        /// 拷贝
        /// </summary>
        public const string COPY = "Ctrl + C";

        /// <summary>
        /// 剪切
        /// </summary>
        public const string CUT = "Ctrl + X";

        /// <summary>
        /// 粘贴
        /// </summary>
        public const string PASTE = "Ctrl + V";

        /// <summary>
        /// 删除
        /// </summary>
        public const string DELETE = "Delete";

        /// <summary>
        /// 上版
        /// </summary>
        public string Take { get; set; } = "F5";

        /// <summary>
        /// 上版继续
        /// </summary>
        public string TakeContinue { get; set; } = "F6";

        /// <summary>
        /// 下版子
        /// </summary>
        public string TakeOut { get; set; } = "F7";

        /// <summary>
        /// 上板更新
        /// </summary>
        public string TakeUpdate { get; set; } = "F8";

        /// <summary>
        /// 打开下一页
        /// </summary>
        public string OpenNextPage { get; set; } = "F9";

        /// <summary>
        /// Take当前页 & 打开下一页
        /// </summary>
        public string TakeAndOpenNextPage { get; set; } = "F10";

        /// <summary>
        /// 打开当前页 Take & 当前当前页
        /// </summary>
        public string OpenAndTakeSelectedPage { get; set; } = "F11";

        /// <summary>
        /// 保存当前打开的页或模板和项目
        /// </summary>
        public string SaveOpendPageOrTemplateAndProject { get; set; } = "Ctrl + S";
    }
}
