﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VIZ.Framework.Core;

namespace VIZ.Package.Domain
{
    /// <summary>
    /// 包装任务模型
    /// </summary>
    public class PackageTaskModel : ModelBase, IDisposable
    {
        /// <summary>
        /// 包装任务模型
        /// </summary>
        /// <param name="view">插件视图</param>
        public PackageTaskModel(IPluginView view)
        {
            this.View = view;
        }

        #region View -- 插件视图

        private IPluginView view;
        /// <summary>
        /// 插件视图
        /// </summary>
        public IPluginView View
        {
            get { return view; }
            private set { view = value; this.RaisePropertyChanged(nameof(View)); }
        }


        #endregion

        #region ID -- 编号

        private int id;
        /// <summary>
        /// 编号
        /// </summary>
        public int ID
        {
            get { return id; }
            set { id = value; this.RaisePropertyChanged(nameof(ID)); }
        }

        #endregion

        #region Name -- 名称

        private string name;
        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; this.RaisePropertyChanged(nameof(Name)); }
        }

        #endregion

        #region Remark -- 备注

        private string remark;
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark
        {
            get { return remark; }
            set { remark = value; this.RaisePropertyChanged(nameof(Remark)); }
        }

        #endregion

        #region IsEnabled -- 是否启用

        private bool isEnabled;
        /// <summary>
        /// 是否启用
        /// </summary>
        public bool IsEnabled
        {
            get { return isEnabled; }
            set { isEnabled = value; this.RaisePropertyChanged(nameof(IsEnabled)); }
        }

        #endregion

        #region Status -- 状态

        private PackageTaskStatus status;
        /// <summary>
        /// 状态
        /// </summary>
        public PackageTaskStatus Status
        {
            get { return status; }
            set { status = value; this.RaisePropertyChanged(nameof(Status)); }
        }

        #endregion

        #region ErrorMessage -- 错误消息

        private string errorMessage;
        /// <summary>
        /// 错误消息
        /// </summary>
        public string ErrorMessage
        {
            get { return errorMessage; }
            set { errorMessage = value; this.RaisePropertyChanged(nameof(ErrorMessage)); }
        }

        #endregion

        #region PreviewUpdateTime -- 预览更新时间

        private DateTime? previewUpdateTime;
        /// <summary>
        /// 预览更新时间
        /// </summary>
        public DateTime? PreviewUpdateTime
        {
            get { return previewUpdateTime; }
            set { previewUpdateTime = value; this.RaisePropertyChanged(nameof(PreviewUpdateTime)); }
        }

        #endregion

        #region TakeUpdateTime -- 上版更新时间

        private DateTime? takeUpdateTime;
        /// <summary>
        /// 上版更新时间
        /// </summary>
        public DateTime? TakeUpdateTime
        {
            get { return takeUpdateTime; }
            set { takeUpdateTime = value; this.RaisePropertyChanged(nameof(TakeUpdateTime)); }
        }

        #endregion

        /// <summary>
        /// 包装任务接口
        /// </summary>
        public IPackageTaskInterface PackageTaskInterface { get; set; }

        /// <summary>
        /// 预览更新行为
        /// </summary>
        public Action<ConnModel> PreviewUpdateAction { get; set; }

        /// <summary>
        /// 上版更新行为
        /// </summary>
        public Action<ConnModel> TakeUpdateAction { get; set; }

        /// <summary>
        /// 预览更新
        /// </summary>
        public void PreviewUpdate()
        {
            if (!this.IsEnabled || this.PreviewUpdateAction == null)
                return;

            this.PackageTaskInterface?.PreviewUpdate(this);

            this.PreviewUpdateTime = DateTime.Now;
        }

        /// <summary>
        /// 上版更新
        /// </summary>
        public void TakeUpdate()
        {
            if (!this.IsEnabled || this.TakeUpdateAction == null)
                return;

            this.PackageTaskInterface?.TakeUpdate(this);

            this.TakeUpdateTime = DateTime.Now;
        }

        /// <summary>
        /// 销毁
        /// </summary>
        public void Dispose()
        {
            this.PackageTaskInterface?.Dispose(this);
        }
    }
}
